/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.client.UnlistedProperty;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCableBusLandingParticle;
import appeng.core.sync.packets.PacketClick;
import appeng.helpers.AEGlassMaterial;
import appeng.integration.abstraction.IAEFacade;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.CableBusTESR;
import appeng.tile.networking.TileCableBus;
import appeng.tile.networking.TileCableBusTESR;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCableBus
extends AEBaseTileBlock
implements IAEFacade {
    public static final UnlistedProperty<CableBusRenderState> RENDER_STATE_PROPERTY = new UnlistedProperty<CableBusRenderState>("cable_bus_render_state", CableBusRenderState.class);
    private static final ICableBusContainer NULL_CABLE_BUS = new NullCableBusContainer();

    public BlockCableBus() {
        super(AEGlassMaterial.INSTANCE);
        this.func_149713_g(0);
        this.setFullSize(false);
        this.setOpaque(false);
        this.setTileEntity(TileCableBus.class);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{RENDER_STATE_PROPERTY});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        CableBusRenderState renderState = this.cb(world, pos).getRenderState();
        renderState.setWorld(world);
        renderState.setPos(pos);
        return ((IExtendedBlockState)state).withProperty(RENDER_STATE_PROPERTY, (Object)renderState);
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        this.cb((IBlockAccess)worldIn, pos).randomDisplayTick(worldIn, pos, rand);
    }

    public void onNeighborChange(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        this.cb(w, pos).onNeighborChanged(w, pos, neighbor);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180656_a(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        return this.cb(w, pos).isProvidingWeakPower(side.func_176734_d());
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_180634_a(World w, BlockPos pos, IBlockState state, Entity entityIn) {
        this.cb((IBlockAccess)w, pos).onEntityCollision(entityIn);
    }

    public int func_176211_b(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        return this.cb(w, pos).isProvidingStrongPower(side.func_176734_d());
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return state.func_177230_c().getLightValue(state, world, pos);
        }
        return this.cb(world, pos).getLightValue();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.cb(world, pos).isLadder(entity);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        return this.cb(w, pos).isSolidOnSide(side);
    }

    public boolean func_176200_f(IBlockAccess w, BlockPos pos) {
        return this.cb(w, pos).isEmpty();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        Object tile;
        if (player.field_71075_bZ.field_75098_d && (tile = this.getTileEntity((IBlockAccess)world, pos)) != null) {
            ((AEBaseTile)tile).disableDrops();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        if (side == null) {
            side = EnumFacing.UP;
        }
        return this.cb(w, pos).canConnectRedstone(EnumSet.of(side));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Vec3d v3 = target.field_72307_f.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        SelectedPart sp = this.cb((IBlockAccess)world, pos).selectPart(v3);
        if (sp.part != null) {
            return sp.part.getItemStack(PartItemStack.PICK);
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        if (Platform.getRandom().nextBoolean()) {
            return true;
        }
        ICableBusContainer cb = this.cb((IBlockAccess)world, target.func_178782_a());
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        TextureAtlasSprite texture = Platform.pickRandom(cableBusModel.getParticleTextures(renderState));
        if (texture != null) {
            double x = target.field_72307_f.field_72450_a;
            double y = target.field_72307_f.field_72448_b;
            double z = target.field_72307_f.field_72449_c;
            Particle fx = new DestroyFX(world, x, y, z, 0.0, 0.0, 0.0, state).func_174846_a(target.func_178782_a()).func_70541_f(0.8f);
            fx.func_187117_a(texture);
            effectRenderer.func_78873_a(fx);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        ICableBusContainer cb = this.cb((IBlockAccess)world, pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        List<TextureAtlasSprite> textures = cableBusModel.getParticleTextures(renderState);
        if (!textures.isEmpty()) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        TextureAtlasSprite texture = Platform.pickRandom(textures);
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        ParticleDigging particle = new DestroyFX(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, this.func_176223_P()).func_174846_a(pos);
                        particle.func_187117_a(texture);
                        effectRenderer.func_78873_a((Particle)particle);
                    }
                }
            }
        }
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            this.addRunningParticle(world, pos, entity);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addRunningParticle(World world, BlockPos pos, Entity entity) {
        ICableBusContainer cb = this.cb((IBlockAccess)world, pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        TextureAtlasSprite texture = this.getSpriteForParticle(renderState, cableBusModel);
        if (texture != null) {
            double d0 = entity.field_70165_t + (double)((world.field_73012_v.nextFloat() - 0.5f) * entity.field_70130_N);
            double d1 = entity.func_174813_aQ().field_72338_b + (double)0.1f;
            double d2 = entity.field_70161_v + (double)((world.field_73012_v.nextFloat() - 0.5f) * entity.field_70130_N);
            ParticleDigging particle = new DestroyFX(world, d0, d1, d2, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, this.func_176223_P()).func_174846_a(pos);
            particle.func_187117_a(texture);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        if (!world.field_72995_K) {
            PacketCableBusLandingParticle packet = new PacketCableBusLandingParticle(pos, (Entity)entity, numberOfParticles);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 32.0);
            NetworkHandler.instance().sendToAllTracking(packet, point);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addLandingParticle(BlockPos pos, double entityX, double entityY, double entityZ, int numberOfParticles) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ICableBusContainer cb = this.cb((IBlockAccess)world, pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        TextureAtlasSprite texture = this.getSpriteForParticle(cb.getRenderState(), cableBusModel);
        if (texture != null) {
            Vec3d startVec = new Vec3d(entityX, entityY, entityZ);
            Vec3d endVec = startVec.func_72441_c(0.0, -4.0, 0.0);
            RayTraceResult result = world.func_147447_a(startVec, endVec, true, false, true);
            double speed = 0.15f;
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && numberOfParticles != 0) {
                for (int i = 0; i < numberOfParticles; ++i) {
                    double d0 = world.field_73012_v.nextGaussian() * (double)0.15f;
                    double d1 = world.field_73012_v.nextGaussian() * (double)0.15f;
                    double d2 = world.field_73012_v.nextGaussian() * (double)0.15f;
                    ParticleDigging particle = new DestroyFX((World)world, entityX, entityY, entityZ, d0, d1, d2, this.func_176223_P()).func_174846_a(pos);
                    particle.func_187117_a(texture);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite getSpriteForParticle(CableBusRenderState renderState, CableBusBakedModel cableBusModel) {
        FacadeRenderState frs = renderState.getFacades().get(EnumFacing.UP);
        if (frs != null) {
            IBlockState state = frs.getSourceBlock();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
            return model.func_177554_e();
        }
        return Platform.pickRandom(cableBusModel.getParticleTextures(renderState));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (Platform.isServer()) {
            this.cb((IBlockAccess)world, pos).onNeighborChanged((IBlockAccess)world, pos, fromPos);
        }
    }

    private ICableBusContainer cb(IBlockAccess w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        CableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = ((TileCableBus)te).getCableBus();
        }
        return out == null ? NULL_CABLE_BUS : out;
    }

    @Nullable
    private IFacadeContainer fc(IBlockAccess w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        IFacadeContainer out = null;
        if (te instanceof TileCableBus) {
            out = ((TileCableBus)te).getCableBus().getFacadeContainer();
        }
        return out;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        RayTraceResult rtr;
        if (Platform.isClient() && (rtr = Minecraft.func_71410_x().field_71476_x) != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK && pos.equals((Object)rtr.func_178782_a())) {
            Vec3d hitVec = rtr.field_72307_f.func_178788_d(new Vec3d((Vec3i)pos));
            if (this.cb((IBlockAccess)worldIn, pos).clicked(playerIn, EnumHand.MAIN_HAND, hitVec)) {
                NetworkHandler.instance().sendToServer(new PacketClick(pos, rtr.field_178784_b, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, EnumHand.MAIN_HAND, true));
            }
        }
    }

    public void onBlockClickPacket(World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, Vec3d hitVec) {
        this.cb((IBlockAccess)worldIn, pos).clicked(playerIn, hand, hitVec);
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.cb((IBlockAccess)w, pos).activate(player, hand, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
    }

    @Override
    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        return this.recolorBlock(world, pos, side, color, null);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color, EntityPlayer who) {
        try {
            return this.cb((IBlockAccess)world, pos).recolourBlock(side, AEColor.values()[color.ordinal()], who);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> itemStacks) {
    }

    public void setupTile() {
        this.setTileEntity(TileCableBus.class);
        GameRegistry.registerTileEntity(TileCableBus.class, (String)("appliedenergistics2".toLowerCase() + ":BlockCableBus"));
        if (Platform.isClient()) {
            BlockCableBus.setupTesr();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setupTesr() {
        GameRegistry.registerTileEntity(TileCableBusTESR.class, (String)("appliedenergistics2".toLowerCase() + ":ClientOnly_TESR_CableBus"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileCableBusTESR.class, (TileEntitySpecialRenderer)new CableBusTESR());
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Override
    public IBlockState getFacadeState(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IFacadePart facade;
        IFacadeContainer container;
        if (side != null && (container = this.fc(world, pos)) != null && (facade = container.getFacade(AEPartLocation.fromFacing(side))) != null) {
            return facade.getBlockState();
        }
        return world.func_180495_p(pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        IFacadePart facade;
        IFacadeContainer container = this.fc(world, pos);
        if (container != null && (facade = container.getFacade(AEPartLocation.fromFacing(side))) != null) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entityIn) {
        IFacadePart facade;
        IFacadeContainer container = this.fc((IBlockAccess)world, pos);
        if (container != null && (facade = container.getFacade(AEPartLocation.fromFacing(EnumFacing.UP))) != null) {
            facade.getBlockState().func_177230_c().func_176199_a(world, pos, entityIn);
        }
        super.func_176199_a(world, pos, entityIn);
    }

    @SideOnly(value=Side.CLIENT)
    private static class DestroyFX
    extends ParticleDigging {
        DestroyFX(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBlockState state) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, state);
        }
    }
}

