/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai.misc;

import com.dhanantry.scapeandrunparasites.block.IMetaName;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.EntityToxicCloud;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAINearestAttackableTargetStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIWanderStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPDispatcher;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityGore;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPItems;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolMeleeBase;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolRangeBase;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigWorld;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityParasiteBase
extends EntityMob {
    protected double killcount = 0.0;
    protected boolean canD = true;
    private int waitInt;
    private boolean canWorkTask;
    private EntityParasiteBase owner;
    private EntityParasiteBase notOwner;
    public boolean canChangeVariant = false;
    private static final DataParameter<Byte> SPECIAL = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> SELFE = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> SKIN = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> COLD_L = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int srpTicks;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    protected int fuseTime = 40;
    protected byte canModRender = 0;
    protected int attackCooldown;
    private byte madeRng = (byte)-1;
    private boolean spawnedByColo;
    protected byte type = 0;
    protected int damageCap = 1;
    protected float MiniDamage = 0.0f;
    protected float miniCap;
    protected boolean miniCapA = false;
    protected byte phaseCreated;
    protected EntityAIJumping jumpT = new EntityAIJumping((EntityLiving)this);
    protected EntityAIWait wait = new EntityAIWait();
    protected EntityAIParasiteFollow folow = new EntityAIParasiteFollow(this, 1.3, 16.0, 6.0, true);
    protected EntityAIWanderStatus aiWander = new EntityAIWanderStatus(this, 1.0, 0.001f, true);
    protected int oneMindDeathValue;
    protected float foodSteal;
    private float aniticks;
    private boolean still;
    private int stillTicks;
    private int canBeStored;
    private int dodFatherID = 0;
    public boolean canSpawnSpawn;
    protected int valueEvDeath;
    protected int liquidLeap;
    protected float blockH;
    protected int BGheight;
    protected int BGrange;
    protected boolean SkillBGflag;
    private ArrayList<String> inbBlockName = new ArrayList();
    private ArrayList<Integer> inbBlockNumber = new ArrayList();
    protected int attacking;
    protected double targetX;
    protected double targetZ;
    protected float leapMotionY;
    protected double jumpSpeed;
    protected int jumpR;
    protected boolean SkillLeapFlag;

    public EntityParasiteBase(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.wait);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.folow);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.jumpT);
        this.canBeStored = 0;
        this.attackCooldown = 0;
        this.canWorkTask = true;
        this.srpTicks = 0;
        this.madeRng = (byte)-1;
        this.foodSteal = 0.001f;
        this.spawnedByColo = false;
        this.SkillBGflag = false;
        this.SkillLeapFlag = false;
        this.canChangeVariant = false;
        this.oneMindDeathValue = 1;
        this.canSpawnSpawn = true;
        this.still = false;
        this.miniCap = SRPConfig.miniminiCap;
    }

    public void setCreatedPhase(byte in) {
        this.phaseCreated = in;
    }

    public abstract int getParasiteIDRegister();

    public void applyBonuses(int colony, int node, byte phase) {
        if (this.spawnedByColo) {
            return;
        }
        this.phaseCreated = phase;
        if (this.phaseCreated >= SRPConfigSystems.evolutionAssimilatedDehiding) {
            this.field_70715_bh.func_75776_a(5, new EntityAINearestAttackableTargetStatus<EntityVillager>(this, EntityVillager.class, true));
        }
        if (this.phaseCreated >= SRPConfigSystems.evolutionTotalKill) {
            this.field_70715_bh.func_75776_a(4, new EntityAINearestAttackableTargetStatus<EntityLivingBase>(this, EntityLivingBase.class, 0, false, false, new Predicate<EntityLivingBase>(){

                public boolean apply(@Nullable EntityLivingBase entity) {
                    return !(entity instanceof EntityPlayer) && !ParasiteEventEntity.checkEntity(entity, SRPConfig.mobattackingBlackList, SRPConfig.mobattackingBlackListWhite);
                }
            }, SRPConfig.adaptedSneakPen, SRPConfig.adaptedInviPen));
        }
        this.setColonyBonus(colony);
        this.setNodeBonus(node);
        this.spawnedByColo = true;
    }

    protected void setColonyBonus(int totalColonyPoints) {
        if (totalColonyPoints == 0) {
            return;
        }
        double bonus = (float)totalColonyPoints / SRPConfigWorld.colonyExtraHealthPoint * SRPConfigWorld.colonyExtraHealthValue;
        double currentV = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(currentV + currentV * bonus);
        this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        bonus = (float)totalColonyPoints / SRPConfigWorld.colonyExtraArmorPoint * SRPConfigWorld.colonyExtraArmorValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfigWorld.colonyExtraDamagePoint * SRPConfigWorld.colonyExtraDamageValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfigWorld.colonyExtraKDResPoint * SRPConfigWorld.colonyExtraKDResValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfigWorld.colonyDamageCapPoint * SRPConfigWorld.colonyDamageCapValue;
        this.damageCap = (int)((double)this.damageCap + (double)this.damageCap * bonus);
    }

    protected void setNodeBonus(int totalPoints) {
        if (totalPoints == 0) {
            return;
        }
        String[] here = new String[3];
        for (String i : SRPConfigWorld.potionEffectForNodes) {
            here = i.split(";");
            int level = Integer.parseInt(here[0]);
            if (totalPoints < level) continue;
            int amp = Integer.parseInt(here[2]);
            Potion potion = Potion.func_180142_b((String)here[1]);
            if (potion == null) continue;
            this.func_70690_d(new PotionEffect(potion, 7777, amp));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL, (Object)0);
        this.field_70180_af.func_187214_a(SELFE, (Object)-1);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(COLD_L, (Object)false);
    }

    public void cannotDespawn(boolean in) {
        this.canD = in;
    }

    public boolean func_70692_ba() {
        return this.canD;
    }

    public void setApplyColonyB(boolean in) {
        this.spawnedByColo = in;
    }

    public boolean getApplyColonyB() {
        return this.spawnedByColo;
    }

    public void func_70636_d() {
        ++this.srpTicks;
        if (this.func_175446_cd()) {
            return;
        }
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        } else {
            super.func_70636_d();
        }
        if (!this.field_70170_p.field_72995_K) {
            byte k = this.getParasiteStatus();
            if (this.getAttackCooldownAni() != 0 || k == 1 || k == 2) {
                if (this.getAttackCooldownAni() != 0) {
                    int i = this.getAttackCooldownAni() - 1;
                    this.setAttackCooldownAni(i);
                }
                if (k == 1 || k == 2) {
                    if (this.func_70638_az() != null) {
                        if (!this.func_70638_az().func_70089_S()) {
                            this.func_70624_b(null);
                            this.setParasiteStatus(0);
                        }
                    } else {
                        this.setParasiteStatus(0);
                        this.func_70624_b(null);
                    }
                }
            }
            if (this.srpTicks % 15 == 0 && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockLiquid && this.func_70638_az() != null) {
                ++this.liquidLeap;
                if (this.liquidLeap > 4) {
                    this.liquidLeap = 4;
                }
            }
            if (this.srpTicks > 20) {
                this.srpTicks = 0;
                if (!this.inbBlockName.isEmpty() && this.field_70146_Z.nextInt(50) == 0) {
                    this.spawnCyst();
                }
                if (this.func_70638_az() instanceof EntityPlayer) {
                    this.fearPlayer(this.func_70638_az());
                }
                if (SRPConfigSystems.useEvolution && this.killcount >= 0.0) {
                    switch (this.phaseCreated) {
                        case 1: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusOne;
                            break;
                        }
                        case 2: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusTwo;
                            break;
                        }
                        case 3: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusThree;
                            break;
                        }
                        case 4: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusFour;
                            break;
                        }
                        case 5: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusFive;
                            break;
                        }
                        case 6: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusSix;
                            break;
                        }
                        case 7: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusSeven;
                            break;
                        }
                        case 8: {
                            this.killcount += SRPConfigSystems.phaseKillCountPlusEight;
                        }
                    }
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.killcount >= 0.0) {
                    this.killcount += SRPConfig.killcountplus;
                }
                this.placeNidus();
            }
            if (this.liquidLeap >= 1) {
                double h = 0.1;
                double str = 0.5;
                this.func_70661_as().func_75499_g();
                EntityLivingBase entitylivingbase = this.func_70638_az();
                if (entitylivingbase != null) {
                    Block bl = this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c();
                    if (!bl.func_176205_b((IBlockAccess)this.field_70170_p, this.func_180425_c())) {
                        h = 0.3;
                        str = 1.0;
                    }
                    --this.liquidLeap;
                    double dd0 = entitylivingbase.field_70165_t - this.field_70165_t;
                    double dd1 = entitylivingbase.field_70161_v - this.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                    this.field_70159_w += dd0 / (double)f * str * (double)0.8f + this.field_70159_w * (double)0.2f;
                    this.field_70179_y += dd1 / (double)f * str * (double)0.8f + this.field_70179_y * (double)0.2f;
                    this.field_70181_x = h;
                    this.func_70671_ap().func_75650_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e(), entitylivingbase.field_70161_v, 10.0f, 40.0f);
                }
            }
        } else if (this.srpTicks > 20) {
            this.srpTicks = 0;
        }
        if (this.field_70165_t == this.field_70169_q && this.field_70161_v == this.field_70166_s) {
            ++this.stillTicks;
        } else {
            this.canBeStored = 55;
            this.stillTicks = 0;
            this.still = false;
        }
        if (this.stillTicks > 25) {
            this.still = true;
        }
        this.aniticks = this.still ? (this.aniticks += 0.0012f) : 0.0f;
        if (this.canBeStored > 0) {
            --this.canBeStored;
        }
    }

    protected void fearPlayer(EntityLivingBase player) {
    }

    protected void placeNidus() {
        if (SRPConfigSystems.useEvolution && this.phaseCreated <= 0) {
            return;
        }
        if (this.field_70170_p.field_73012_v.nextInt(350) != 0 || this.type < 11) {
            return;
        }
        if (this.killcount < 10.0) {
            return;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(SRPConfig.nexussivFollow);
        List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        int collec = 0;
        for (EntityParasiteBase mob : moblist) {
            int idP = mob.getParasiteIDRegister();
            if (idP == 73 || idP == 77 || idP == 78 || idP == 79) {
                return;
            }
            collec = (int)((double)collec + mob.getKillC());
        }
        if (collec < SRPConfig.reinforcerNidusStart) {
            return;
        }
        double d0 = (float)this.field_70165_t + this.field_70170_p.field_73012_v.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70170_p.field_73012_v.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70170_p.field_73012_v.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d4 = d4 * d7 * 2.0;
        EntityGore bomb = new EntityGore(this.field_70170_p);
        bomb.setType((byte)11);
        bomb.func_82149_j((Entity)this);
        bomb.setMotion(d3 *= (d7 *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat() + 0.3f)), d4, d5 *= d7, 0.1, 0.5);
        this.field_70170_p.func_72838_d((Entity)bomb);
    }

    public void setDodFatherID(int in) {
        this.dodFatherID = in;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.canBeStored = 55;
        if (this.madeRng == -1) {
            this.madeRng = (byte)this.field_70146_Z.nextInt(2);
            if (this.madeRng == 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)40);
            }
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76368_d) {
            this.skillBreakBlocks();
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof WeaponToolMeleeBase) {
            super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            if (!this.field_70178_ae) {
                if (this.field_70146_Z.nextInt(5) == 0 && !this.func_70644_a(SRPPotions.RAGE_E)) {
                    this.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 200, 1, false, false));
                }
                super.func_70097_a(source, this.getSkin() == 120 ? amount * (SRPConfig.firemultyplier - SRPConfig.firemultyplier / 2.0f) : amount * SRPConfig.firemultyplier);
            } else {
                return false;
            }
        }
        if (this.notOwner != null) {
            if (this.notOwner.func_70089_S()) {
                if (this.func_70644_a(SRPPotions.PIVOT_E)) {
                    this.notOwner.func_70097_a(source, amount * (float)(this.func_70660_b(SRPPotions.PIVOT_E).func_76458_c() + 1) * SRPConfigSystems.pivotDamageRHost);
                    return super.func_70097_a(source, amount * SRPConfigSystems.pivotDamageRNotHost);
                }
                this.func_184589_d(SRPPotions.PIVOT_E);
                this.notOwner = null;
            } else {
                this.notOwner = null;
            }
        }
        boolean flagWeak = SRPConfig.parasiteWeakToMobs.length > 0 || SRPConfig.parasiteWeakToItems.length > 0 || SRPConfig.parasiteWeakToElse.length > 0;
        boolean flagCap = this.damageCap > 1;
        String damageName = "";
        int naniDesu = 0;
        if (flagWeak || flagCap) {
            if (source.func_76364_f() instanceof EntityPlayer) {
                damageName = ((EntityPlayer)source.func_76346_g()).func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b().getRegistryName().toString();
                naniDesu = 1;
            } else if (source.func_76364_f() instanceof EntityLivingBase) {
                damageName = EntityList.func_191301_a((Entity)source.func_76364_f()).toString();
                naniDesu = 2;
            } else {
                damageName = source.field_76373_n;
                naniDesu = 3;
            }
        }
        if (flagWeak) {
            switch (naniDesu) {
                case 1: {
                    int i;
                    for (i = 0; i < SRPConfig.parasiteWeakToItems.length; ++i) {
                        String[] here;
                        if (SRPConfig.parasiteWeakToItems[i] == null || !(here = SRPConfig.parasiteWeakToItems[i].split(";"))[0].equals(damageName)) continue;
                        amount *= Float.parseFloat(here[1]);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < SRPConfig.parasiteWeakToMobs.length; ++i) {
                        String[] here;
                        if (SRPConfig.parasiteWeakToMobs[i] == null || !(here = SRPConfig.parasiteWeakToMobs[i].split(";"))[0].equals(damageName)) continue;
                        amount *= Float.parseFloat(here[1]);
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < SRPConfig.parasiteWeakToElse.length; ++i) {
                        String[] here;
                        if (SRPConfig.parasiteWeakToElse[i] == null || !(here = SRPConfig.parasiteWeakToElse[i].split(";"))[0].equals(damageName)) continue;
                        amount *= Float.parseFloat(here[1]);
                    }
                    break;
                }
            }
        }
        if (flagCap) {
            switch (naniDesu) {
                case 1: {
                    if (!ParasiteEventEntity.checkName(damageName, SRPConfig.damageCapBlackListItem, SRPConfig.damageCapBlackListWhite)) break;
                    return super.func_70097_a(source, amount);
                }
                case 2: {
                    if (!ParasiteEventEntity.checkName(damageName, SRPConfig.damageCapBlackListMob, SRPConfig.damageCapBlackListWhite)) break;
                    return super.func_70097_a(source, amount);
                }
                case 3: {
                    if (!ParasiteEventEntity.checkName(damageName, SRPConfig.damageCapBlackListElse, SRPConfig.damageCapBlackListWhite)) break;
                    return super.func_70097_a(source, amount);
                }
            }
            float damage = this.func_110138_aP() / (float)this.damageCap + this.func_110138_aP() % (float)this.damageCap * 0.5f;
            if (amount >= damage) {
                source.func_76348_h();
                if (!this.func_70644_a(SRPPotions.RAGE_E)) {
                    this.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 200, 1, false, false));
                }
            }
            return super.func_70097_a(source, Math.min(amount, damage));
        }
        if (SRPConfigSystems.useOneMind && source.func_76364_f() instanceof EntityLivingBase && this.func_70638_az() == source.func_76364_f()) {
            ParasiteEventEntity.alertOthers(this, this.func_70638_az(), this.field_70170_p, 3);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.canBeStored = 55;
        boolean green = entityIn instanceof EntityLivingBase;
        if (green) {
            this.attackEntityAsMobMinimum((EntityLivingBase)entityIn);
        }
        if (flag = super.func_70652_k(entityIn)) {
            if (this.getSkin() == 120) {
                SRPPotions.applyStackPotion(MobEffects.field_76421_d, (EntityLivingBase)entityIn, 100, 1);
            }
            if (green) {
                this.setAttackCooldownAni(100);
                if (SRPConfigSystems.useOneMind) {
                    ParasiteEventEntity.alertOthers(this, (EntityLivingBase)entityIn, this.field_70170_p, 3);
                }
            }
        }
        return flag;
    }

    public boolean attackEntityAsMobMinimum(EntityLivingBase target) {
        if (this.MiniDamage == 0.0f) {
            return false;
        }
        float f1 = target.func_110143_aJ();
        if (f1 <= 0.0f || f1 <= this.miniCap && this.miniCapA) {
            return false;
        }
        if (target instanceof EntityPlayer) {
            ItemStack itemstack1;
            EntityPlayer entityplayer = (EntityPlayer)target;
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return false;
            }
            entityplayer.func_71020_j(this.foodSteal);
            ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
            if (itemstack1.func_77973_b() instanceof ItemShield && entityplayer.func_184585_cz() && !entityplayer.func_184811_cZ().func_185141_a(itemstack1.func_77973_b())) {
                float f12 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                if (this.field_70146_Z.nextFloat() < f12 && this.type >= 31) {
                    entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                    this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                }
                this.func_184590_k(this.MiniDamage);
                return true;
            }
        }
        DamageSource s = DamageSource.func_76358_a((EntityLivingBase)this);
        float damage = 0.0f;
        if (target.func_70644_a(SRPPotions.VIRA_E)) {
            damage = this.MiniDamage * (float)(target.func_70660_b(SRPPotions.VIRA_E).func_76458_c() + 1);
        }
        damage += this.MiniDamage;
        try {
            if (target.func_110142_aN() != null && s != null) {
                target.func_110142_aN().func_94547_a(s, f1, damage);
            }
        }
        catch (Exception f12) {
            // empty catch block
        }
        if (target.func_110139_bj() > 0.0f) {
            target.func_70606_j(f1 - damage / 2.0f);
            target.func_110149_m(target.func_110139_bj() - damage / 2.0f);
        } else {
            target.func_70606_j(f1 - damage);
        }
        this.field_70170_p.func_72960_a((Entity)target, (byte)2);
        if (target.func_110143_aJ() <= 0.0f) {
            ItemStack itemstack = null;
            for (EnumHand enumhand : EnumHand.values()) {
                ItemStack itemstack1 = target.func_184586_b(enumhand);
                if (itemstack1.func_77973_b() != Items.field_190929_cY) continue;
                itemstack = itemstack1.func_77946_l();
                itemstack1.func_190918_g(1);
                break;
            }
            if (itemstack != null) {
                if (target instanceof EntityPlayerMP) {
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)target;
                    entityplayermp.func_71029_a(StatList.func_188057_b((Item)Items.field_190929_cY));
                    CriteriaTriggers.field_193130_A.func_193187_a(entityplayermp, itemstack);
                }
                target.func_70606_j(1.0f);
                target.func_70674_bp();
                target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 900, 1));
                target.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 1));
                target.field_70170_p.func_72960_a((Entity)target, (byte)35);
            } else {
                target.func_70645_a(s);
                this.killcount += 1.0;
            }
        }
        return true;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.killcount >= 0.0) {
            if (this.getSkin() != 120) {
                this.killcount += 1.0;
            } else if (this.field_70146_Z.nextInt(3) == 0) {
                this.killcount += 1.0;
            }
        }
        if (SRPConfigSystems.useEvolution) {
            if (this.func_70644_a(SRPPotions.PIVOT_E)) {
                int amp = this.func_70660_b(SRPPotions.PIVOT_E).func_76458_c();
                SRPSaveData.get(this.field_70170_p).setTotalKills(this.field_70170_p.field_73011_w.getDimension(), SRPConfigSystems.valueKill * (SRPConfigSystems.pivotPointMultiplier * (amp + 1)), true, this.field_70170_p, true);
            } else {
                SRPSaveData.get(this.field_70170_p).setTotalKills(this.field_70170_p.field_73011_w.getDimension(), SRPConfigSystems.valueKill, true, this.field_70170_p, true);
            }
        }
        if (entityLivingIn.func_70644_a(SRPPotions.COTH_E) && this.field_70146_Z.nextDouble() < (double)SRPConfigSystems.cothConvert) {
            ParasiteEventEntity.convertEntity(entityLivingIn, entityLivingIn.getEntityData(), true, SRPConfigSystems.COTHVictimParasite);
        }
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 80, 0, false, false));
        this.setWait(10);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion = potioneffectIn.func_188419_a();
        if (potion == MobEffects.field_76436_u || potion == SRPPotions.COTH_E || potion == SRPPotions.VIRA_E || potion == SRPPotions.CORRO_E || potion == SRPPotions.DLER_E) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (entityIn instanceof EntityBoat || entityIn instanceof EntityMinecart) {
            return false;
        }
        return super.func_184228_n(entityIn);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (cls == EntityPlayer.class || cls == EntityPlayerMP.class) {
            return true;
        }
        String name = null;
        try {
            name = EntityList.func_191306_a(cls).toString();
        }
        catch (Exception e) {
            return true;
        }
        if (name == null) {
            return true;
        }
        if (name.contains("srparasites")) {
            return false;
        }
        return !SRPConfig.mobAttackingFull || !ParasiteEventEntity.checkName(name, SRPConfig.mobattackingBlackList, SRPConfig.mobattackingBlackListWhite);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount) {
            return false;
        }
        if (this instanceof EntityLiving && this.func_104002_bU()) {
            return false;
        }
        return type.func_75598_a().isAssignableFrom(((Object)((Object)this)).getClass());
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            Item wea = player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
            if (wea == SRPItems.itemEvolve) {
                this.killcount += 1.0E9;
                this.killcount += 1.0E9;
                this.killcount += 1.0E9;
            } else if (wea == SRPItems.itemDevolve) {
                this.canChangeVariant = true;
                this.func_70645_a(DamageSource.field_76377_j);
                this.func_70106_y();
            } else if (wea == SRPItems.itemVariant) {
                this.canChangeVariant = true;
                this.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
                this.canChangeVariant = false;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public int canBeStored() {
        return this.canBeStored;
    }

    public int getSelfeState() {
        return (Integer)this.field_70180_af.func_187225_a(SELFE);
    }

    public void setSelfeState(int state) {
        this.field_70180_af.func_187227_b(SELFE, (Object)state);
    }

    public float getMiniDamage() {
        return this.MiniDamage;
    }

    public int getLLeap() {
        return this.liquidLeap;
    }

    public void setWorkTask(boolean in) {
        this.canWorkTask = in;
    }

    public boolean shouldWorkTask() {
        return this.canWorkTask;
    }

    public void setParasiteToFollow(@Nullable EntityParasiteBase in) {
        this.owner = in;
    }

    public EntityParasiteBase getParasiteFollowing() {
        if (this.owner != null) {
            if (this.owner.func_70089_S()) {
                return this.owner;
            }
            this.setParasiteToFollow(null);
        }
        return null;
    }

    public void SetRooter(@Nullable EntityParasiteBase in) {
        this.notOwner = in;
    }

    public EntityParasiteBase getRooter() {
        if (this.notOwner != null) {
            if (this.notOwner.func_70089_S()) {
                return this.notOwner;
            }
            this.SetRooter(null);
        }
        return null;
    }

    public byte getParasiteStatus() {
        return (Byte)this.field_70180_af.func_187225_a(SPECIAL);
    }

    public void setParasiteStatus(int state) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)((byte)state));
    }

    public void setWait(int in) {
        this.waitInt = in;
    }

    public int getWait() {
        return this.waitInt;
    }

    public void resetIdleTime() {
        this.field_70708_bq = 0;
    }

    public byte getPhaseCreated() {
        return this.phaseCreated;
    }

    public int getSkin() {
        return ((Byte)this.field_70180_af.func_187225_a(SKIN)).intValue();
    }

    public boolean getColdL() {
        return (Boolean)this.field_70180_af.func_187225_a(COLD_L);
    }

    public void setSkin(int texture) {
        if (this.getSkin() == 120) {
            if (!this.canChangeVariant) {
                return;
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                return;
            }
        }
        this.field_70180_af.func_187227_b(SKIN, (Object)((byte)texture));
    }

    public int getCCDeathValue() {
        return this.oneMindDeathValue;
    }

    public void setAttackCooldownAni(int i) {
        this.attackCooldown = i;
    }

    public int getAttackCooldownAni() {
        return this.attackCooldown;
    }

    public void setKillC(double i) {
        this.killcount = i;
    }

    public double getKillC() {
        return this.killcount;
    }

    public byte getParasiteType() {
        return this.type;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.spawnCyst();
            ParasiteEventEntity.spawnBeckon(this.field_70170_p, cause, this);
            ParasiteEventEntity.leaveScent(this.field_70170_p, cause, this);
            if (SRPConfigSystems.useEvolution && !this.func_70644_a(SRPPotions.DEBAR_E)) {
                SRPSaveData.get(this.field_70170_p).setTotalKills(this.field_70170_p.field_73011_w.getDimension(), -this.valueEvDeath, true, this.field_70170_p, false);
            }
            if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityPlayer) {
                this.checkWeapon((EntityPlayer)cause.func_76346_g());
            }
        }
    }

    private void checkWeapon(EntityPlayer playerIn) {
        if (!SRPConfigSystems.useScent) {
            return;
        }
        Item ga = playerIn.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
        if ((ga instanceof WeaponToolMeleeBase || ga instanceof WeaponToolRangeBase) && this.field_70146_Z.nextInt(10) == 0) {
            playerIn.func_70690_d(new PotionEffect(SRPPotions.PREY_E, 600, 0, false, false));
        }
    }

    protected void func_70609_aI() {
        if (this.canModRender == 1) {
            if (this.madeRng == 0) {
                this.setSelfeState(1);
                this.setParasiteStatus(6);
                this.dyingBurst(true, 1);
            } else {
                this.onDeathUpdateOG();
            }
        } else if (this.canModRender == 2) {
            if (this.madeRng == 0) {
                this.selfExplode();
                this.OnDeathHelper();
            } else {
                this.onDeathUpdateOG();
            }
        } else {
            this.onDeathUpdateOG();
        }
    }

    protected void onDeathUpdateOG() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) && !this.func_70644_a(SRPPotions.DEBAR_E)) {
                int j;
                int i;
                if (SRPConfigSystems.useEvolution) {
                    if (SRPSaveData.get(this.field_70170_p).getEvolutionPhase(this.field_70170_p.field_73011_w.getDimension()) < SRPConfigSystems.evolutionPArasitesWithoutXP) {
                        i = this.func_70693_a(this.field_70717_bb);
                        for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                            j = EntityXPOrb.func_70527_a((int)i);
                            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                        }
                    }
                } else {
                    i = this.func_70693_a(this.field_70717_bb);
                    for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                    }
                }
            }
            this.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                for (int k = 0; k < 20; ++k) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
            }
        }
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i <= 0 || this.timeSinceIgnited == 0) {
            // empty if block
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
            if (fromDeath) {
                this.OnDeathHelper();
            }
        }
    }

    public void OnDeathHelper() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
    }

    protected void selfExplode() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnEffectsGore();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.spawnGore();
            this.func_184185_a(SRPSounds.MOBEXPLOTION, 1.0f, 1.0f);
            this.field_70729_aU = true;
            this.func_70106_y();
            EntityToxicCloud entityareaeffectcloud = new EntityToxicCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.setRadius(this.field_70130_N, this.field_70131_O);
            entityareaeffectcloud.setWaitTime(10);
            entityareaeffectcloud.setDuration(entityareaeffectcloud.getDuration() / 2);
            entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
            entityareaeffectcloud.addEffect(new PotionEffect(MobEffects.field_76436_u, 300, 0));
            entityareaeffectcloud.addEffect(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    protected void spawnGore() {
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
    }

    public boolean func_70601_bi() {
        if (SRPConfigSystems.useEvolution) {
            if (this.phaseCreated >= SRPConfigSystems.evolutionSpawningIgnoreSunlight) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
                return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        if (SRPConfig.ignoreL) {
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if (this.func_104002_bU()) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.spawnCyst();
                this.storeBefDes();
                this.func_70106_y();
            }
        } else {
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entity != null) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.spawnCyst();
                    this.storeBefDes();
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d3 > 1024.0 && this.func_70692_ba()) {
                    this.spawnCyst();
                    this.storeBefDes();
                    this.func_70106_y();
                } else if (d3 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    protected void storeBefDes() {
        Entity dod;
        if (this.dodFatherID != 0 && (dod = this.field_70170_p.func_73045_a(this.dodFatherID)) != null && dod.func_70089_S() && dod instanceof EntityPDispatcher) {
            ((EntityPDispatcher)dod).storeParasite(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidLightLevelOne() {
        if (this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite) {
            return this.isValidLightLevelTwo();
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        if (i > this.field_70146_Z.nextInt(8)) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        return true;
    }

    protected boolean isValidLightLevelTwo() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int light = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos);
        if (light > this.field_70146_Z.nextInt(1000) || light > 7) {
            return false;
        }
        return this.field_70146_Z.nextInt(8) == 0;
    }

    private boolean isInParasiteBiome() {
        return this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData floo = super.func_180482_a(difficulty, livingdata);
        if (SRPConfigSystems.useEvolution) {
            this.phaseCreated = SRPSaveData.get(this.field_70170_p).getEvolutionPhase(this.field_70170_p.field_73011_w.getDimension());
            if (this.phaseCreated >= SRPConfigSystems.evolutionParasiteStatIncrease) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (double)(1.0f + SRPConfigSystems.evolutionParasiteStatIncreaseValue));
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b() * (double)(1.0f + SRPConfigSystems.evolutionParasiteStatIncreaseValue));
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * (double)(1.0f + SRPConfigSystems.evolutionParasiteStatIncreaseValue));
            }
        }
        return floo;
    }

    protected boolean applyColdBiome() {
        boolean flag;
        Biome c = this.field_70170_p.func_180494_b(this.func_180425_c());
        boolean bl = flag = this.field_70146_Z.nextInt(1) == 0 && this.canChangeVariant;
        if (c.func_180626_a(this.func_180425_c()) < 0.15f || c.func_150559_j() || flag) {
            this.setSkin(120);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 0.6);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 1.4);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b() * 1.3);
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("parasitetype", this.getSkin());
        compound.func_74757_a("parasitedespawn", this.func_70692_ba());
        compound.func_74776_a("parasitekills", (float)this.getKillC());
        compound.func_74757_a("parasitecolob", this.getApplyColonyB());
        compound.func_74757_a("parasitecoldl", ((Boolean)this.field_70180_af.func_187225_a(COLD_L)).booleanValue());
        compound.func_74774_a("phasecreat", this.phaseCreated);
        NBTTagList allResS = new NBTTagList();
        NBTTagList allResI = new NBTTagList();
        if (this.inbBlockName.size() != this.inbBlockNumber.size()) {
            return;
        }
        for (int i = 0; i < this.inbBlockName.size(); ++i) {
            String res = this.inbBlockName.get(i);
            NBTTagCompound resT = new NBTTagCompound();
            resT.func_74778_a("blocks" + i, res);
            allResS.func_74742_a((NBTBase)resT);
            int resi = this.inbBlockNumber.get(i);
            NBTTagCompound resU = new NBTTagCompound();
            resU.func_74768_a("blocki" + i, resi);
            allResI.func_74742_a((NBTBase)resU);
        }
        compound.func_74782_a("srpinvblocksname", (NBTBase)allResS);
        compound.func_74782_a("srpinvblocksnumber", (NBTBase)allResI);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("parasitetype", 99)) {
            this.setSkin(compound.func_74762_e("parasitetype"));
        }
        if (compound.func_150297_b("parasitedespawn", 99)) {
            this.cannotDespawn(compound.func_74767_n("parasitedespawn"));
        }
        if (compound.func_150297_b("parasitekills", 99)) {
            this.setKillC(compound.func_74760_g("parasitekills"));
        }
        if (compound.func_150297_b("parasitecolob", 99)) {
            this.setApplyColonyB(compound.func_74767_n("parasitecolob"));
        }
        if (compound.func_150297_b("parasitecoldl", 99)) {
            this.field_70180_af.func_187227_b(COLD_L, (Object)compound.func_74767_n("parasitecoldl"));
        }
        if (compound.func_150297_b("phasecreat", 99)) {
            this.phaseCreated = compound.func_74771_c("phasecreat");
        }
        if (compound.func_74764_b("srpinvblocksname")) {
            NBTTagList allResS = compound.func_150295_c("srpinvblocksname", 10);
            NBTTagList allResI = compound.func_150295_c("srpinvblocksnumber", 10);
            if (allResS.func_74745_c() != allResI.func_74745_c()) {
                return;
            }
            for (int i = 0; i < allResS.func_74745_c(); ++i) {
                NBTTagCompound resT = allResS.func_150305_b(i);
                String res = resT.func_74779_i("blocks" + i);
                this.inbBlockName.add(i, res);
                NBTTagCompound resU = allResI.func_150305_b(i);
                int resi = resU.func_74762_e("blocki" + i);
                this.inbBlockNumber.add(i, resi);
            }
        }
    }

    public void particleStatus(byte id) {
        this.field_70170_p.func_72960_a((Entity)this, id);
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnEffectsGore() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 5: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.RHAPPY, 0, 0, 0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
                break;
            }
            case 7: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.EXPLOSION_LARGE);
                }
                break;
            }
            case 8: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.BIOMASS, 0, 0, 0);
                }
                break;
            }
            case 10: {
                for (int i = 0; i <= 40; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 11: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 12: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 13: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GSPLASH, 4, -1, -1);
                }
                break;
            }
            case 40: {
                this.madeRng = 0;
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                int iddd = Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_177977_b()));
                for (int i = 0; i <= 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{iddd});
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(EnumParticleTypes particleType) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesGore(SRPEnumParticle particleType, int r, int g, int b) {
        this.spawnParticlesGore(particleType, r, g, b, 1.0, 4.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesGore(SRPEnumParticle particleType, int r, int g, int b, double xF, double yF) {
        double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70146_Z.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d3 = d3 * (d7 *= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() + 0.3f)) * xF;
        d4 = d4 * d7 * yF;
        d5 = d5 * d7 * xF;
        d3 = Math.min(d3, 0.2) * (Math.random() * 2.0 - 1.0);
        d4 = Math.min(d4, 0.6) * (Math.random() * 2.0 - 1.0);
        d5 = Math.min(d5, 0.2) * (Math.random() * 2.0 - 1.0);
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t, this.field_70163_u + 0.2 + (double)this.field_70131_O, this.field_70161_v, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesGoreMouth(SRPEnumParticle particleType, int r, int g, int b, double xF, double yF) {
        double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70146_Z.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d3 = d3 * (d7 *= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() + 0.3f)) * xF;
        d4 = d4 * d7 * yF;
        d5 = d5 * d7 * xF;
        d3 = Math.min(d3, 0.2) * (Math.random() * 2.0 - 1.0);
        d4 = Math.min(d4, 0.6) * (Math.random() * 2.0 - 1.0);
        d5 = Math.min(d5, 0.2) * (Math.random() * 2.0 - 1.0);
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t, this.field_70163_u, this.field_70161_v, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesGoreBox(SRPEnumParticle particleType, int r, int g, int b, double xF, double yF) {
        double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70146_Z.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d3 = d3 * (d7 *= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() + 0.3f)) * xF;
        d4 = d4 * d7 * yF;
        d5 = d5 * d7 * xF;
        d3 = Math.min(d3, 0.2) * (Math.random() * 2.0 - 1.0);
        d4 = Math.min(d4, 0.6) * (Math.random() * 2.0 - 1.0);
        d5 = Math.min(d5, 0.2) * (Math.random() * 2.0 - 1.0);
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b, double d0, double d1, double d2, double d3, double d4, double d5) {
        ParticleSpawner.spawnParticle(particleType, d0, d1, d2, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getscale(float p_70831_1_) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getStillAni() {
        return this.still;
    }

    @SideOnly(value=Side.CLIENT)
    public float getAniTick() {
        return this.aniticks;
    }

    public void doSpecialSkill(byte id) {
        switch (id) {
            case 13: {
                this.skillBreakBlocks();
                return;
            }
            case 14: {
                this.skillLeap();
                return;
            }
        }
    }

    public boolean getFinished(byte attID) {
        switch (attID) {
            case 13: {
                return this.SkillBGflag;
            }
            case 14: {
                return this.SkillLeapFlag;
            }
        }
        return false;
    }

    public void setFinished(byte attID, boolean in) {
        switch (attID) {
            case 13: {
                this.SkillBGflag = in;
            }
            case 14: {
                this.SkillLeapFlag = in;
            }
        }
    }

    public void setSkillBreakBlocksValues(float hardness, int heightIn, int rangeIn) {
        this.blockH = hardness;
        this.BGheight = heightIn;
        this.BGrange = rangeIn;
    }

    public float getBlockH() {
        if (this.getSkin() == 120) {
            return this.blockH * 1.5f;
        }
        if (this.getSkin() == 7) {
            return this.blockH * 2.0f;
        }
        return this.blockH;
    }

    public void skillBreakBlocks() {
        EntityLivingBase target;
        if (this.field_70128_L) {
            return;
        }
        if (this.getBlockH() == 0.0f) {
            return;
        }
        int blocksbroke = 0;
        if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            return;
        }
        int i1 = MathHelper.func_76128_c((double)(this.field_70163_u + 0.1));
        double l1 = this.field_70165_t;
        double i2 = this.field_70161_v;
        boolean flag = false;
        int Brangeatm = this.BGrange;
        int offsetT = 0;
        if (this.func_70638_az() != null && (target = this.func_70638_az()).func_70092_e(this.field_70165_t, target.field_70163_u, this.field_70161_v) < 9.0) {
            if (target.field_70163_u - this.field_70163_u < -1.0) {
                offsetT -= 2;
                if (!this.field_70122_E) {
                    --offsetT;
                }
            } else if (target.field_70163_u - this.field_70163_u > 2.0) {
                ++offsetT;
                this.BGrange = 0;
            }
        }
        for (int k2 = -1 * this.BGrange; k2 <= 1 * this.BGrange; ++k2) {
            for (int l2 = -1 * this.BGrange; l2 <= 1 * this.BGrange; ++l2) {
                for (int j = 1 + offsetT; j <= this.BGheight + offsetT; ++j) {
                    String name;
                    double i3 = l1 + (double)k2;
                    double k = i1 + j;
                    double l = i2 + (double)l2;
                    BlockPos blockpos = new BlockPos(i3, k, l);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    float bHard = iblockstate.func_185887_b(this.field_70170_p, blockpos);
                    if (!(bHard <= this.getBlockH()) || !(bHard > 0.0f) || block instanceof IMetaName && block != SRPBlocks.ParasiteCanister || block == SRPBlocks.BiomeHeart || block == SRPBlocks.ColonyHeart || block == SRPBlocks.ParasiteRubbleDense || block == SRPBlocks.ParasiteCanisterActive || block == SRPBlocks.dodN || block instanceof BlockLiquid || block instanceof BlockPortal || block instanceof BlockEndGateway || block instanceof BlockEndPortalFrame || iblockstate.func_185904_a() == Material.field_151567_E || this.blockException(name = block.getRegistryName().toString()) || block == Blocks.field_150350_a || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                    if (SRPConfig.cystActive) {
                        int meta = block.func_176201_c(iblockstate);
                        boolean bl = flag = this.destroyBlockPos(blockpos, false) || flag;
                        if (SRPConfig.doTileDrops) {
                            this.addToBlockInv(name + ";" + meta);
                        }
                    } else {
                        this.destroyBlockPos(blockpos, SRPConfig.doTileDrops);
                    }
                    ++blocksbroke;
                }
            }
        }
        this.BGrange = Brangeatm;
        this.SkillBGflag = true;
    }

    protected boolean destroyBlockPos(BlockPos pos, boolean dropBlock) {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, pos)) {
            return false;
        }
        if (this.field_70146_Z.nextDouble() < SRPConfig.blockParticleChance) {
            this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        }
        if (this.field_70146_Z.nextDouble() < SRPConfig.blockSoundChance) {
            SoundType soundtype = block.getSoundType(Block.func_176220_d((int)Block.func_176210_f((IBlockState)iblockstate)), this.field_70170_p, pos, null);
            this.field_70170_p.func_184133_a((EntityPlayer)null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        if (dropBlock && this.field_70146_Z.nextDouble() < SRPConfig.blockDropChance) {
            block.func_176226_b(this.field_70170_p, pos, iblockstate, 0);
        }
        return this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    protected boolean blockException(String name) {
        return ParasiteEventEntity.checkName(name, SRPConfig.parasiteGriefingBlackList, SRPConfig.parasiteGriefingWhite);
    }

    public void addToBlockInv(String name) {
        boolean flag = true;
        for (int i = 0; i < this.inbBlockName.size(); ++i) {
            if (!this.inbBlockName.get(i).equals(name) || this.inbBlockNumber.get(i) > 64) continue;
            int iiii = this.inbBlockNumber.get(i) + 1;
            this.inbBlockNumber.set(i, iiii);
            flag = false;
            break;
        }
        if (flag) {
            if (this.inbBlockName.size() >= 22) {
                this.spawnCyst();
            }
            this.inbBlockName.add(name);
            this.inbBlockNumber.add(1);
        }
    }

    protected void spawnCyst() {
        if (this.inbBlockName.isEmpty()) {
            return;
        }
        double d0 = (float)this.field_70165_t + this.field_70170_p.field_73012_v.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70170_p.field_73012_v.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70170_p.field_73012_v.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d4 = d4 * d7 * 2.0;
        EntityGore bomb = new EntityGore(this.field_70170_p);
        bomb.setType((byte)10);
        bomb.func_82149_j((Entity)this);
        bomb.setMotion(d3 *= (d7 *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat() + 0.3f)), d4, d5 *= d7, 0.25, 0.75);
        this.field_70170_p.func_72838_d((Entity)bomb);
        bomb.inbBlockName = new ArrayList<String>(this.inbBlockName);
        bomb.inbBlockNumber = new ArrayList<Integer>(this.inbBlockNumber);
        this.inbBlockName = new ArrayList();
        this.inbBlockNumber = new ArrayList();
    }

    public void setskillLeapValues(float leapY, double leapSpeed, int jumpRad) {
        this.leapMotionY = leapY;
        this.jumpSpeed = leapSpeed;
        this.jumpR = jumpRad;
    }

    protected void skillLeap() {
        if (this.leapMotionY == 0.0f) {
            return;
        }
        if (this.func_70638_az() != null && this.shouldWorkTask() && !this.func_70644_a(MobEffects.field_76421_d) && this.getParasiteStatus() <= 2) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (this.attacking == 0) {
                ++this.attacking;
                this.targetX = entitylivingbase.field_70165_t;
                this.targetZ = entitylivingbase.field_70161_v;
            }
        }
        if (this.attacking >= 1) {
            ++this.attacking;
            this.skillBreakBlocks();
            if (this.attacking == 2 && this.field_70122_E) {
                this.setParasiteStatus(10);
                this.func_70661_as().func_75499_g();
                double d0 = this.targetX - this.field_70165_t;
                double d1 = this.targetZ - this.field_70161_v;
                double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70181_x = this.leapMotionY;
                this.field_70159_w += d0 / f * this.jumpSpeed * 0.9 + this.field_70159_w * 0.3;
                this.field_70179_y += d1 / f * this.jumpSpeed * 0.9 + this.field_70179_y * 0.3;
            }
            if (this.attacking > 2 && this.field_70122_E) {
                if (this.jumpR != 0) {
                    float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b((double)this.jumpR, 2.0, (double)this.jumpR);
                    List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                    for (EntityLivingBase mob : moblist) {
                        if (mob == this || mob instanceof EntityParasiteBase) continue;
                        mob.func_70653_a((Entity)mob, 2.5f, this.field_70165_t - mob.field_70165_t, this.field_70161_v - mob.field_70161_v);
                        this.func_70652_k((Entity)mob);
                    }
                }
                this.setParasiteStatus(0);
                this.attacking = 0;
                if (this.type >= 31 && this.field_70131_O > 2.0f) {
                    this.func_184185_a(SRPSounds.HITGROUND, 15.0f, 1.0f);
                }
                this.SkillLeapFlag = true;
            }
        }
    }

    public class EntityAIJumping
    extends EntityAIBase {
        private final EntityLiving parent;
        private int secs;

        public EntityAIJumping(EntityLiving parentIn) {
            this.parent = parentIn;
            this.func_75248_a(4);
            if (parentIn.func_70661_as() instanceof PathNavigateGround) {
                ((PathNavigateGround)parentIn.func_70661_as()).func_179693_d(true);
            } else if (parentIn.func_70661_as() instanceof PathNavigateFlying) {
                ((PathNavigateFlying)parentIn.func_70661_as()).func_192877_c(true);
            }
        }

        public boolean func_75250_a() {
            ++this.secs;
            if (this.secs < 10) {
                return false;
            }
            this.secs = 0;
            EntityLivingBase target = this.parent.func_70638_az();
            if (target == null) {
                return false;
            }
            if (target.func_70092_e(this.parent.field_70165_t, target.field_70163_u, this.parent.field_70161_v) < 4.0 && target.field_70163_u - (this.parent.field_70163_u + (double)this.parent.func_70047_e()) > 1.0 && this.parent.field_70122_E) {
                this.parent.func_70661_as().func_75499_g();
                double dd0 = target.field_70165_t - this.parent.field_70165_t;
                double dd1 = target.field_70161_v - this.parent.field_70161_v;
                float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                this.parent.field_70159_w += dd0 / (double)f * 0.5 * (double)0.8f + this.parent.field_70159_w * (double)0.2f;
                this.parent.field_70179_y += dd1 / (double)f * 0.5 * (double)0.8f + this.parent.field_70179_y * (double)0.2f;
                this.parent.field_70181_x = 0.2 + (double)this.parent.field_70131_O * 0.15;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.parent.func_70681_au().nextFloat() < 0.8f) {
                this.parent.func_70683_ar().func_75660_a();
            }
        }
    }

    class EntityAIWait
    extends EntityAIBase {
        public EntityAIWait() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityParasiteBase.this.getWait() > 0;
        }

        public void func_75246_d() {
        }
    }
}

