/*
 * Decompiled with CFR 0.152.
 */
package coolsquid.logfilters;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import coolsquid.logfilters.LogFilter;
import java.io.File;
import java.util.Map;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;

@Mod(modid="logfilters", name="LogFilters", version="1.0.2", dependencies="required-after:forge@[14.21.1.2387,)", updateJSON="https://gist.githubusercontent.com/coolsquid/39d310b4b62141761164e854d1d452da/raw/logfilters.json", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class LogFilters
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String MODID = "logfilters";
    public static final String NAME = "LogFilters";
    public static final String VERSION = "1.0.2";
    public static final String DEPENDENCIES = "required-after:forge@[14.21.1.2387,)";
    public static final String UPDATE_JSON = "https://gist.githubusercontent.com/coolsquid/39d310b4b62141761164e854d1d452da/raw/logfilters.json";

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return LogFilters.class.getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public Void call() throws Exception {
        Logger internal = LogManager.getFormatterLogger((String)NAME);
        internal.info("Setting up log filters");
        File file = new File("config/LogFilters.conf");
        if (!file.exists()) {
            file.createNewFile();
        }
        Config config = ConfigFactory.parseFile((File)file);
        for (Map.Entry e : config.entrySet()) {
            Logger log;
            String key = (String)e.getKey();
            Logger logger = key.equals("root") ? LogManager.getRootLogger() : (log = LogManager.getLogger((String)(key.startsWith("\"") && key.endsWith("\"") ? key.substring(1, key.length() - 1) : key)));
            if (log instanceof org.apache.logging.log4j.core.Logger) {
                for (Config filter : config.getConfigList(key)) {
                    LogFilter logFilter;
                    switch (filter.getString("type")) {
                        case "prefix": {
                            logFilter = new LogFilter.PrefixFilter(filter.getString("filter"));
                            break;
                        }
                        case "suffix": {
                            logFilter = new LogFilter.SuffixFilter(filter.getString("filter"));
                            break;
                        }
                        case "regex": {
                            logFilter = new LogFilter.RegexFilter(filter.getString("filter"));
                            break;
                        }
                        case "equals": {
                            logFilter = new LogFilter.EqualsFilter(filter.getString("filter"));
                            break;
                        }
                        case "contains": {
                            logFilter = new LogFilter.ContainsFilter(filter.getString("filter"));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unrecognized filter type " + filter.getString("type"));
                        }
                    }
                    if (filter.hasPath("max_level")) {
                        logFilter.setMaxLevel(Level.valueOf((String)filter.getString("max_level").toUpperCase()));
                    }
                    ((org.apache.logging.log4j.core.Logger)log).addFilter((Filter)logFilter);
                }
                continue;
            }
            internal.error("Logger %s [%s] is not supported", (Object)key, (Object)log.getClass().getName());
        }
        return null;
    }
}

