/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import java.util.Arrays;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class FluidCraftingPatternDetails
implements ICraftingPatternDetails,
Comparable<ICraftingPatternDetails> {
    private final IAEItemStack[] containerInputs = new IAEItemStack[9];
    private final IAEItemStack[] remainingInputs = new IAEItemStack[9];
    private final IAEItemStack[] containerOutputs = new IAEItemStack[1];
    private final IAEItemStack[] fluidInputs = new IAEItemStack[9];
    private final IAEItemStack pattern;
    private final ItemStack patternItem;
    private final boolean canSubstitute;
    private final boolean isNecessary;
    private int priority = 0;

    public static FluidCraftingPatternDetails GetFluidPattern(ItemStack pattern, World w) {
        try {
            return new FluidCraftingPatternDetails(pattern, w);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public FluidCraftingPatternDetails(ItemStack pattern, World w) {
        NBTTagCompound encodedValue = pattern.func_77978_p();
        this.pattern = AEItemStack.fromItemStack((ItemStack)pattern);
        this.patternItem = pattern;
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        if (!encodedValue.func_74767_n("crafting")) {
            throw new IllegalArgumentException("Not Crafting pattern!");
        }
        NBTTagList inTag = encodedValue.func_150295_c("in", 10);
        this.canSubstitute = encodedValue.func_74767_n("substitute");
        InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int x = 0; x < inTag.func_74745_c(); ++x) {
            NBTTagCompound resultItemTag = inTag.func_150305_b(x);
            ItemStack gs = new ItemStack(resultItemTag);
            if (resultItemTag.func_74764_b("stackSize")) {
                gs.func_190920_e(resultItemTag.func_74762_e("stackSize"));
            }
            crafting.func_70299_a(x, gs);
            this.containerInputs[x] = AEItemStack.fromItemStack((ItemStack)gs);
        }
        IRecipe standardRecipe = CraftingManager.func_192413_b((InventoryCrafting)crafting, (World)w);
        if (standardRecipe == null) {
            throw new IllegalStateException("No pattern here!");
        }
        ItemStack outputItem = standardRecipe.func_77572_b(crafting);
        NonNullList remain = standardRecipe.func_179532_b(crafting);
        for (int x = 0; x < remain.size(); ++x) {
            this.remainingInputs[x] = AEItemStack.fromItemStack((ItemStack)((ItemStack)remain.get(x)));
        }
        this.containerOutputs[0] = AEItemStack.fromItemStack((ItemStack)outputItem);
        for (int x = 0; x < 9; ++x) {
            ItemStack drained;
            IAEItemStack filledContainer = this.containerInputs[x];
            IAEItemStack emptyContainer = this.remainingInputs[x];
            this.fluidInputs[x] = filledContainer != null && emptyContainer != null && Util.getFluidFromItem(filledContainer.getDefinition()) != null && emptyContainer.equals(drained = Util.getEmptiedContainer(filledContainer.getDefinition())) ? FakeFluids.packFluid2AEDrops(Util.getFluidFromItem(filledContainer.getDefinition())) : filledContainer;
        }
        this.isNecessary = Arrays.stream(this.fluidInputs).anyMatch(t -> t != null && t.getItem() instanceof ItemFluidDrop);
    }

    public ItemStack getPattern() {
        return this.patternItem;
    }

    public boolean isValidItemForSlot(int i, ItemStack itemStack, World world) {
        return false;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.fluidInputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return FluidPatternDetails.condenseStacks(this.fluidInputs);
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.containerOutputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.containerOutputs;
    }

    public IAEItemStack[] getOriginInputs() {
        return this.containerInputs;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public ItemStack getOutput(InventoryCrafting inventoryCrafting, World world) {
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int i) {
        this.priority = i;
    }

    @Override
    public int compareTo(ICraftingPatternDetails o) {
        return Integer.compare(o.getPriority(), this.priority);
    }

    public boolean isNecessary() {
        return this.isNecessary;
    }

    public boolean equals(Object obj) {
        return obj instanceof FluidCraftingPatternDetails && this.pattern.equals(((FluidCraftingPatternDetails)obj).pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }
}

