/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.proxy;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IWirelessTermHandler;
import appeng.core.features.ItemDefinition;
import appeng.recipes.game.DisassembleRecipe;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.tile.TileBurette;
import com.glodblock.github.common.tile.TileDualInterface;
import com.glodblock.github.common.tile.TileFluidAssembler;
import com.glodblock.github.common.tile.TileFluidDiscretizer;
import com.glodblock.github.common.tile.TileFluidLevelMaintainer;
import com.glodblock.github.common.tile.TileFluidPacketDecoder;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.common.tile.TileGasDiscretizer;
import com.glodblock.github.common.tile.TileIngredientBuffer;
import com.glodblock.github.common.tile.TileLargeIngredientBuffer;
import com.glodblock.github.common.tile.TileTrioInterface;
import com.glodblock.github.common.tile.TileUltimateEncoder;
import com.glodblock.github.handler.RegistryHandler;
import com.glodblock.github.integration.mek.FCGasBlocks;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.integration.mek.GasInterfaceUtil;
import com.glodblock.github.integration.opencomputer.OCInit;
import com.glodblock.github.integration.pauto.PackagedFluidCrafting;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.loader.ChannelLoader;
import com.glodblock.github.loader.FCBlocks;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    public final RegistryHandler regHandler = this.createRegistryHandler();
    public final SimpleNetworkWrapper netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("ae2fc");

    public RegistryHandler createRegistryHandler() {
        return new RegistryHandler();
    }

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this.regHandler);
        FCBlocks.init(this.regHandler);
        FCItems.init(this.regHandler);
        FakeFluids.init();
        if (ModAndClassUtil.GAS) {
            FCGasItems.init(this.regHandler);
            FCGasBlocks.init(this.regHandler);
            FakeGases.init();
        }
        GameRegistry.registerTileEntity(TileFluidDiscretizer.class, (ResourceLocation)FluidCraft.resource("fluid_discretizer"));
        GameRegistry.registerTileEntity(TileFluidPatternEncoder.class, (ResourceLocation)FluidCraft.resource("fluid_pattern_encoder"));
        GameRegistry.registerTileEntity(TileFluidPacketDecoder.class, (ResourceLocation)FluidCraft.resource("fluid_packet_decoder"));
        GameRegistry.registerTileEntity(TileIngredientBuffer.class, (ResourceLocation)FluidCraft.resource("ingredient_buffer"));
        GameRegistry.registerTileEntity(TileLargeIngredientBuffer.class, (ResourceLocation)FluidCraft.resource("large_ingredient_buffer"));
        GameRegistry.registerTileEntity(TileBurette.class, (ResourceLocation)FluidCraft.resource("burette"));
        GameRegistry.registerTileEntity(TileDualInterface.class, (ResourceLocation)FluidCraft.resource("dual_interface"));
        GameRegistry.registerTileEntity(TileFluidLevelMaintainer.class, (ResourceLocation)FluidCraft.resource("fluid_level_maintainer"));
        GameRegistry.registerTileEntity(TileFluidAssembler.class, (ResourceLocation)FluidCraft.resource("fluid_assembler"));
        GameRegistry.registerTileEntity(TileUltimateEncoder.class, (ResourceLocation)FluidCraft.resource("ultimate_encoder"));
        if (ModAndClassUtil.GAS) {
            GameRegistry.registerTileEntity(TileGasDiscretizer.class, (ResourceLocation)FluidCraft.resource("gas_discretizer"));
            GameRegistry.registerTileEntity(TileTrioInterface.class, (ResourceLocation)FluidCraft.resource("trio_interface"));
        }
        new ChannelLoader().run();
        if (ModAndClassUtil.AUTO_P) {
            this.initPackagedAutoIntegration();
        }
        if (ModAndClassUtil.OC) {
            OCInit.run();
        }
    }

    protected void initPackagedAutoIntegration() {
        PackagedFluidCrafting.init();
    }

    public void init(FMLInitializationEvent event) {
        this.regHandler.onInit();
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)FCItems.WIRELESS_FLUID_PATTERN_TERMINAL);
        IRecipe disassembleRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation("appliedenergistics2", "disassemble"));
        if (disassembleRecipe instanceof DisassembleRecipe) {
            Ae2Reflect.getDisassemblyNonCellMap((DisassembleRecipe)disassembleRecipe).put(CommonProxy.createItemDefn((Item)FCItems.DENSE_ENCODED_PATTERN), AEApi.instance().definitions().materials().blankPattern());
            Ae2Reflect.getDisassemblyNonCellMap((DisassembleRecipe)disassembleRecipe).put(CommonProxy.createItemDefn((Item)FCItems.DENSE_CRAFT_ENCODED_PATTERN), AEApi.instance().definitions().materials().blankPattern());
            Ae2Reflect.getDisassemblyNonCellMap((DisassembleRecipe)disassembleRecipe).put(CommonProxy.createItemDefn((Item)FCItems.LARGE_ITEM_ENCODED_PATTERN), AEApi.instance().definitions().materials().blankPattern());
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        Upgrades.PATTERN_EXPANSION.registerItem(new ItemStack((Block)FCBlocks.DUAL_INTERFACE), 3);
        Upgrades.CRAFTING.registerItem(new ItemStack((Block)FCBlocks.DUAL_INTERFACE), 1);
        Upgrades.CAPACITY.registerItem(new ItemStack((Block)FCBlocks.DUAL_INTERFACE), 2);
        Upgrades.PATTERN_EXPANSION.registerItem(new ItemStack((Item)FCItems.PART_DUAL_INTERFACE), 3);
        Upgrades.CRAFTING.registerItem(new ItemStack((Item)FCItems.PART_DUAL_INTERFACE), 1);
        Upgrades.CRAFTING.registerItem(new ItemStack((Item)FCItems.PART_DUAL_INTERFACE), 2);
        Upgrades.CRAFTING.registerItem(AEApi.instance().definitions().parts().fluidExportBus(), 1);
        Upgrades.MAGNET.registerItem(new ItemStack((Item)FCItems.WIRELESS_FLUID_PATTERN_TERMINAL), 1);
        if (ModAndClassUtil.GAS) {
            GasInterfaceUtil.addUpgrade();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)FluidCraft.INSTANCE, (IGuiHandler)new InventoryHandler());
    }

    private static IItemDefinition createItemDefn(Item item) {
        return new ItemDefinition(Objects.requireNonNull(item.getRegistryName()).toString(), item);
    }

    public SimpleNetworkWrapper getNetHandler() {
        return this.netHandler;
    }
}

