/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.core.AELog;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.container.ContainerFCCraftConfirm;
import com.glodblock.github.client.container.ContainerItemAmountChange;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.network.SPacketSetItemAmount;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.ModAndClassUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CPacketInventoryAction
implements IMessage {
    private Action action;
    private int slot;
    private long id;
    private IAEItemStack stack;
    private boolean isEmpty;

    public CPacketInventoryAction() {
    }

    public CPacketInventoryAction(Action action, int slot, int id, IAEItemStack stack) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = stack;
        this.isEmpty = stack == null || stack.getDefinition().func_190926_b();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slot);
        buf.writeLong(this.id);
        buf.writeBoolean(this.isEmpty);
        if (!this.isEmpty) {
            try {
                this.stack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.slot = buf.readInt();
        this.id = buf.readLong();
        this.isEmpty = buf.readBoolean();
        if (!this.isEmpty) {
            this.stack = AEItemStack.fromPacket((ByteBuf)buf);
        }
    }

    public static enum Action {
        CHANGE_AMOUNT,
        AUTO_CRAFT,
        REQUEST_JOB;

    }

    public static class Handler
    implements IMessageHandler<CPacketInventoryAction, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketInventoryAction message, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            sender.func_71121_q().func_152344_a(() -> {
                if (sender.field_71070_bA instanceof AEBaseContainer) {
                    AEBaseContainer baseContainer = (AEBaseContainer)sender.field_71070_bA;
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (message.action == Action.CHANGE_AMOUNT && context != null) {
                        InventoryHandler.openGui((EntityPlayer)sender, Ae2Reflect.getContextWorld(context), new BlockPos(Ae2Reflect.getContextX(context), Ae2Reflect.getContextY(context), Ae2Reflect.getContextZ(context)), context.getSide().getFacing(), GuiType.ITEM_AMOUNT_SET);
                        int amt = (int)message.stack.getStackSize();
                        if (message.stack.getItem() == FCItems.FLUID_PACKET) {
                            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(message.stack);
                            amt = fluid == null ? 1 : fluid.amount;
                        } else if (ModAndClassUtil.GAS && message.stack.getItem() == FCGasItems.GAS_PACKET) {
                            GasStack gas = (GasStack)FakeItemRegister.getStack(message.stack);
                            amt = gas == null ? 1 : gas.amount;
                        }
                        FluidCraft.proxy.netHandler.sendTo((IMessage)new SPacketSetItemAmount(amt), sender);
                        if (sender.field_71070_bA instanceof ContainerItemAmountChange) {
                            ContainerItemAmountChange iac = (ContainerItemAmountChange)sender.field_71070_bA;
                            if (message.stack != null) {
                                iac.getPatternValue().func_75215_d(message.stack.getDefinition());
                                iac.setValueIndex(message.slot);
                                iac.setInitValue(message.stack.getStackSize());
                            }
                            iac.func_75142_b();
                        }
                    }
                    if (message.action == Action.AUTO_CRAFT && context != null) {
                        InventoryHandler.openGui((EntityPlayer)sender, Ae2Reflect.getContextWorld(context), new BlockPos(Ae2Reflect.getContextX(context), Ae2Reflect.getContextY(context), Ae2Reflect.getContextZ(context)), context.getSide().getFacing(), GuiType.FLUID_CRAFT_AMOUNT);
                        if (sender.field_71070_bA instanceof ContainerCraftAmount) {
                            ContainerCraftAmount cca = (ContainerCraftAmount)sender.field_71070_bA;
                            if (message.stack != null) {
                                cca.getCraftingItem().func_75215_d(message.stack.getDefinition());
                                cca.setItemToCraft(message.stack);
                            }
                            cca.func_75142_b();
                        }
                    }
                    if (message.action == Action.REQUEST_JOB) {
                        Object target = baseContainer.getTarget();
                        if (context != null && target instanceof IActionHost && baseContainer instanceof ContainerCraftAmount) {
                            IActionHost ah = (IActionHost)target;
                            IGridNode gn = ah.getActionableNode();
                            IGrid g = gn.getGrid();
                            ContainerCraftAmount cca = (ContainerCraftAmount)baseContainer;
                            if (cca.getItemToCraft() == null) {
                                return;
                            }
                            cca.getItemToCraft().setStackSize(message.id);
                            Future futureJob = null;
                            try {
                                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                                futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                                InventoryHandler.openGui((EntityPlayer)sender, Ae2Reflect.getContextWorld(context), new BlockPos(Ae2Reflect.getContextX(context), Ae2Reflect.getContextY(context), Ae2Reflect.getContextZ(context)), context.getSide().getFacing(), GuiType.FLUID_CRAFT_CONFIRM);
                                if (sender.field_71070_bA instanceof ContainerFCCraftConfirm) {
                                    ContainerFCCraftConfirm ccc = (ContainerFCCraftConfirm)sender.field_71070_bA;
                                    ccc.setAutoStart(message.slot == 1);
                                    ccc.setJob(futureJob);
                                    cca.func_75142_b();
                                }
                            }
                            catch (Throwable e) {
                                if (futureJob != null) {
                                    futureJob.cancel(true);
                                }
                                AELog.debug((Throwable)e);
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

