/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.pauto;

import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.integration.pauto.RecipeInfoFluidProcessing;
import com.glodblock.github.loader.FCBlocks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class RecipeTypeFluidProcessing
implements IRecipeType {
    public static final RecipeTypeFluidProcessing INSTANCE = new RecipeTypeFluidProcessing();
    private static final ResourceLocation NAME = FluidCraft.resource("fluid_processing");
    private static final IntSet SLOTS;
    private static final Color SLOT_COLOUR;
    private static final int NUM_SLOTS_CRAFT = 81;
    private static final int NUM_SLOTS_OUT = 9;

    private RecipeTypeFluidProcessing() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)"ae2fc.pauto.fluid_processing.name");
    }

    public String getLocalizedNameShort() {
        return I18n.func_74838_a((String)"ae2fc.pauto.fluid_processing.name_short");
    }

    public IRecipeInfo getNewRecipeInfo() {
        return new RecipeInfoFluidProcessing();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public boolean canSetOutput() {
        return true;
    }

    public boolean hasMachine() {
        return false;
    }

    public List<String> getJEICategories() {
        return PackagedAutoJEIPlugin.getAllRecipeCategories();
    }

    @SideOnly(value=Side.CLIENT)
    public Object getRepresentation() {
        return new ItemStack((Block)FCBlocks.FLUID_PATTERN_ENCODER);
    }

    @SideOnly(value=Side.CLIENT)
    public Color getSlotColor(int slot) {
        return SLOT_COLOUR;
    }

    @Optional.Method(modid="jei")
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayout recipeLayout, String category) {
        Int2ObjectOpenHashMap tfrs = new Int2ObjectOpenHashMap();
        int ndxCrafting = 0;
        int ndxOutput = 0;
        for (IGuiIngredient ing : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            ItemStack stack;
            if (ing.isInput()) {
                if (ndxCrafting >= 81 || (stack = (ItemStack)ing.getDisplayedIngredient()) == null) continue;
                tfrs.put(ndxCrafting++, (Object)stack);
                continue;
            }
            if (ndxOutput >= 9 || (stack = (ItemStack)ing.getDisplayedIngredient()) == null) continue;
            tfrs.put(81 + ndxOutput++, (Object)stack);
        }
        for (IGuiIngredient ing : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
            if (ing.isInput()) {
                if (ndxCrafting >= 81) continue;
                tfrs.put(ndxCrafting++, (Object)FakeFluids.packFluid2Packet((FluidStack)ing.getDisplayedIngredient()));
                continue;
            }
            if (ndxOutput >= 9) continue;
            tfrs.put(81 + ndxOutput++, (Object)FakeFluids.packFluid2Packet((FluidStack)ing.getDisplayedIngredient()));
        }
        return tfrs;
    }

    static {
        SLOT_COLOUR = new Color(9145260);
        IntOpenHashSet slots = new IntOpenHashSet();
        for (int i = 0; i < 90; ++i) {
            slots.add(i);
        }
        SLOTS = IntSets.unmodifiable((IntSet)slots);
    }
}

