/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.integration.mek;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemGasDrop;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeItemHandler;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import java.util.Objects;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FakeGases {
    public static void init() {
        FakeItemRegister.registerHandler(ItemGasDrop.class, new FakeItemHandler<GasStack, IAEGasStack>(){

            @Override
            public GasStack getStack(ItemStack stack) {
                if (stack.func_190926_b() || stack.func_77973_b() != FCGasItems.GAS_DROP || !stack.func_77942_o()) {
                    return null;
                }
                NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
                if (!tag.func_150297_b("Gas", 8)) {
                    return null;
                }
                Gas gas = GasRegistry.getGas((String)tag.func_74779_i("Gas"));
                if (gas == null) {
                    return null;
                }
                return new GasStack(gas, stack.func_190916_E());
            }

            @Override
            public GasStack getStack(@Nullable IAEItemStack stack) {
                return stack == null ? null : this.getStack(stack.createItemStack());
            }

            @Override
            public IAEGasStack getAEStack(ItemStack stack) {
                return this.getAEStack((IAEItemStack)AEItemStack.fromItemStack((ItemStack)stack));
            }

            @Override
            public IAEGasStack getAEStack(@Nullable IAEItemStack stack) {
                if (stack == null) {
                    return null;
                }
                GasStack gas = this.getStack(stack.createItemStack());
                if (gas == null || gas.getGas() == null) {
                    return null;
                }
                AEGasStack gasStack = AEGasStack.of((GasStack)gas);
                gasStack.setStackSize(stack.getStackSize());
                return gasStack;
            }

            @Override
            public ItemStack packStack(GasStack gas) {
                if (gas == null || gas.amount <= 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = new ItemStack((Item)FCGasItems.GAS_DROP, gas.amount);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Gas", gas.getGas().getName());
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public ItemStack displayStack(GasStack target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IAEItemStack packAEStack(GasStack gas) {
                if (gas == null || gas.amount <= 0) {
                    return null;
                }
                AEItemStack stack = AEItemStack.fromItemStack((ItemStack)this.packStack(gas));
                if (stack == null) {
                    return null;
                }
                stack.setStackSize((long)gas.amount);
                return stack;
            }

            @Override
            public IAEItemStack packAEStackLong(IAEGasStack gas) {
                if (gas == null || gas.getStackSize() <= 0L) {
                    return null;
                }
                AEItemStack stack = AEItemStack.fromItemStack((ItemStack)this.packStack(new GasStack(gas.getGas(), 1)));
                if (stack == null) {
                    return null;
                }
                stack.setStackSize(gas.getStackSize());
                return stack;
            }
        });
        FakeItemRegister.registerHandler(ItemGasPacket.class, new FakeItemHandler<GasStack, IAEGasStack>(){

            @Override
            public GasStack getStack(ItemStack stack) {
                if (stack.func_190926_b() || !stack.func_77942_o()) {
                    return null;
                }
                GasStack gas = GasStack.readFromNBT((NBTTagCompound)Objects.requireNonNull(stack.func_77978_p()).func_74775_l("GasStack"));
                return gas != null && gas.amount > 0 ? gas : null;
            }

            @Override
            public GasStack getStack(@Nullable IAEItemStack stack) {
                return stack != null ? this.getStack(stack.createItemStack()) : null;
            }

            @Override
            public IAEGasStack getAEStack(ItemStack stack) {
                return this.getAEStack((IAEItemStack)AEItemStack.fromItemStack((ItemStack)stack));
            }

            @Override
            public IAEGasStack getAEStack(@Nullable IAEItemStack stack) {
                if (stack == null) {
                    return null;
                }
                GasStack gas = this.getStack(stack.createItemStack());
                if (gas == null || gas.getGas() == null) {
                    return null;
                }
                return AEGasStack.of((GasStack)gas);
            }

            @Override
            public ItemStack packStack(GasStack gas) {
                if (gas == null || gas.amount == 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = new ItemStack((Item)FCGasItems.GAS_PACKET);
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound fluidTag = new NBTTagCompound();
                gas.write(fluidTag);
                tag.func_74782_a("GasStack", (NBTBase)fluidTag);
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public ItemStack displayStack(GasStack gas) {
                if (gas == null) {
                    return ItemStack.field_190927_a;
                }
                GasStack copy = gas.copy();
                copy.amount = 1000;
                ItemStack stack = new ItemStack((Item)FCGasItems.GAS_PACKET);
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound fluidTag = new NBTTagCompound();
                copy.write(fluidTag);
                tag.func_74782_a("GasStack", (NBTBase)fluidTag);
                tag.func_74757_a("DisplayOnly", true);
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public IAEItemStack packAEStack(GasStack target) {
                return AEItemStack.fromItemStack((ItemStack)this.packStack(target));
            }

            @Override
            public IAEItemStack packAEStackLong(IAEGasStack target) {
                return AEItemStack.fromItemStack((ItemStack)this.packStack(target.getGasStack()));
            }
        });
    }

    public static boolean isGasFakeItem(ItemStack stack) {
        return stack.func_77973_b() == FCGasItems.GAS_DROP || stack.func_77973_b() == FCGasItems.GAS_PACKET;
    }

    public static ItemStack packGas2Drops(@Nullable GasStack stack) {
        return FakeItemRegister.packStack(stack, FCGasItems.GAS_DROP);
    }

    public static IAEItemStack packGas2AEDrops(@Nullable GasStack stack) {
        return FakeItemRegister.packAEStack(stack, FCGasItems.GAS_DROP);
    }

    public static IAEItemStack packGas2AEDrops(@Nullable IAEGasStack stack) {
        return FakeItemRegister.packAEStackLong(stack, FCGasItems.GAS_DROP);
    }

    public static ItemStack packGas2Packet(@Nullable GasStack stack) {
        return FakeItemRegister.packStack(stack, FCGasItems.GAS_PACKET);
    }

    public static IAEItemStack packGas2AEPacket(@Nullable GasStack stack) {
        return FakeItemRegister.packAEStack(stack, FCGasItems.GAS_PACKET);
    }

    public static ItemStack displayGas(@Nullable GasStack stack) {
        return FakeItemRegister.displayStack(stack, FCGasItems.GAS_PACKET);
    }
}

