/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod;

import com.glodblock.github.coremod.transform.AEBaseTilePartTransformer;
import com.glodblock.github.coremod.transform.ContainerCraftConfirmTransformer;
import com.glodblock.github.coremod.transform.ContainerInterfaceTerminalTransformer;
import com.glodblock.github.coremod.transform.ContainerPatternEncoderTransformer;
import com.glodblock.github.coremod.transform.CraftingCpuTransformer;
import com.glodblock.github.coremod.transform.CraftingTreeNodeTransformer;
import com.glodblock.github.coremod.transform.DualityInterfaceTransformer;
import com.glodblock.github.coremod.transform.GuiBridgeTransformer;
import com.glodblock.github.coremod.transform.GuiContainerWrapperTransformer;
import com.glodblock.github.coremod.transform.GuiCraftingStatusTransformer;
import com.glodblock.github.coremod.transform.GuiCraftingTransformer;
import com.glodblock.github.coremod.transform.PartTypeTransformer;
import com.glodblock.github.coremod.transform.PautoCraftingPatternHelperTransformer;
import com.glodblock.github.coremod.transform.TileUnpackagerTransformer;
import com.glodblock.github.coremod.transform.WCTGuiCraftingTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FCClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] code) {
        ClassMapper tform;
        switch (transformedName) {
            case "appeng.crafting.CraftingTreeNode": {
                tform = CraftingTreeNodeTransformer.INSTANCE;
                break;
            }
            case "appeng.helpers.DualityInterface": {
                tform = DualityInterfaceTransformer.INSTANCE;
                break;
            }
            case "appeng.me.cluster.implementations.CraftingCPUCluster": {
                tform = CraftingCpuTransformer.INSTANCE;
                break;
            }
            case "appeng.items.parts.PartType": {
                tform = PartTypeTransformer.INSTANCE;
                break;
            }
            case "appeng.core.sync.GuiBridge": {
                tform = GuiBridgeTransformer.INSTANCE;
                break;
            }
            case "thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternHelper": {
                tform = PautoCraftingPatternHelperTransformer.TFORM_INPUTS;
                break;
            }
            case "thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternHelper": {
                tform = PautoCraftingPatternHelperTransformer.TFORM_OUTPUTS;
                break;
            }
            case "thelm.packagedauto.tile.TileUnpackager": {
                tform = TileUnpackagerTransformer.INSTANCE;
                break;
            }
            case "mezz.jei.input.GuiContainerWrapper": {
                tform = GuiContainerWrapperTransformer.INSTANCE;
                break;
            }
            case "appeng.container.implementations.ContainerInterfaceTerminal": 
            case "appeng.container.implementations.ContainerInterfaceConfigurationTerminal": 
            case "appeng.container.implementations.ContainerFluidInterfaceConfigurationTerminal": {
                tform = ContainerInterfaceTerminalTransformer.INSTANCE;
                break;
            }
            case "appeng.client.gui.implementations.GuiCraftingCPU": 
            case "appeng.client.gui.implementations.GuiCraftConfirm": {
                tform = GuiCraftingTransformer.INSTANCE;
                break;
            }
            case "appeng.client.gui.implementations.GuiCraftingStatus": {
                tform = GuiCraftingStatusTransformer.INSTANCE;
                break;
            }
            case "p455w0rd.wct.client.gui.GuiCraftingCPU": 
            case "p455w0rd.wct.client.gui.GuiCraftConfirm": {
                tform = WCTGuiCraftingTransformer.INSTANCE;
                break;
            }
            case "appeng.tile.AEBaseTile": 
            case "appeng.parts.AEBasePart": {
                tform = AEBaseTilePartTransformer.INSTANCE;
                break;
            }
            case "appeng.container.implementations.ContainerPatternEncoder": {
                tform = ContainerPatternEncoderTransformer.INSTANCE;
                break;
            }
            case "appeng.container.implementations.ContainerCraftConfirm": {
                tform = ContainerCraftConfirmTransformer.INSTANCE;
                break;
            }
            default: {
                return code;
            }
        }
        System.out.println("[AE2FC] Transforming class: " + transformedName);
        return tform.transformClass(code);
    }

    public static abstract class ClassMapper
    implements Transform {
        @Override
        public byte[] transformClass(byte[] code) {
            ClassReader reader = new ClassReader(code);
            ClassWriter writer = new ClassWriter(reader, this.getWriteFlags());
            reader.accept(this.getClassMapper((ClassVisitor)writer), 0);
            return writer.toByteArray();
        }

        protected int getWriteFlags() {
            return 0;
        }

        protected abstract ClassVisitor getClassMapper(ClassVisitor var1);
    }

    public static interface Transform {
        public byte[] transformClass(byte[] var1);
    }
}

