/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileUltimateEncoder
extends AEBaseInvTile
implements ITerminalHost {
    private final AppEngInternalInventory pattern = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private final AppEngInternalInventory craft = new AppEngInternalInventory((IAEAppEngInventory)this, 42);
    private final AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 8);
    public boolean fluidFirst;
    public boolean combine;

    @Nonnull
    public IItemHandler getInternalInventory() {
        return this.pattern;
    }

    public AppEngInternalInventory getCraft() {
        return this.craft;
    }

    public AppEngInternalInventory getOutput() {
        return this.output;
    }

    public AppEngInternalInventory getPattern() {
        return this.pattern;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.craft.readFromNBT(data.func_74775_l("craft"));
        this.output.readFromNBT(data.func_74775_l("output"));
        this.fluidFirst = data.func_74767_n("fluidFirst");
        this.combine = data.func_74767_n("combine");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        this.craft.writeToNBT(data, "craft");
        this.output.writeToNBT(data, "output");
        data.func_74757_a("fluidFirst", this.fluidFirst);
        data.func_74757_a("combine", this.combine);
        return data;
    }

    public void onChangeCrafting(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        ItemStack item;
        int x;
        Util.clearItemInventory((IItemHandlerModifiable)this.craft);
        Util.clearItemInventory((IItemHandlerModifiable)this.output);
        ItemStack[] fuzzyFind = new ItemStack[Util.findMax((Collection<Integer>)inputs.keySet()) + 1];
        IntIterator intIterator = inputs.keySet().iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            Util.fuzzyTransferItems(index, (ItemStack[])inputs.get(index), fuzzyFind, (IItemList<IAEItemStack>)Util.getItemChannel().createList());
        }
        if (combine) {
            fuzzyFind = Util.compress(fuzzyFind);
        }
        int bound = Math.min(this.craft.getSlots(), fuzzyFind.length);
        for (x = 0; x < bound; ++x) {
            item = fuzzyFind[x];
            this.craft.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
        }
        bound = Math.min(this.output.getSlots(), outputs.size());
        for (x = 0; x < bound; ++x) {
            item = outputs.get(x);
            this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
        }
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ItemStack is;
        if (slot == 1 && !(is = inv.getStackInSlot(1)).func_190926_b() && is.func_77973_b() instanceof ItemEncodedPattern) {
            ItemEncodedPattern pattern = (ItemEncodedPattern)is.func_77973_b();
            ICraftingPatternDetails details = pattern.getPatternForItem(is, this.func_145831_w());
            if (details != null) {
                ItemStack packet;
                IAEItemStack item;
                int x;
                Util.clearItemInventory((IItemHandlerModifiable)this.craft);
                Util.clearItemInventory((IItemHandlerModifiable)this.output);
                for (x = 0; x < this.craft.getSlots() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    if (item != null && item.getItem() == FCItems.FLUID_DROP) {
                        packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                        this.craft.setStackInSlot(x, packet);
                        continue;
                    }
                    if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                        packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                        this.craft.setStackInSlot(x, packet);
                        continue;
                    }
                    this.craft.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
                for (x = 0; x < this.output.getSlots() && x < details.getOutputs().length; ++x) {
                    item = details.getOutputs()[x];
                    if (item != null && item.getItem() == FCItems.FLUID_DROP) {
                        packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                        this.output.setStackInSlot(x, packet);
                        continue;
                    }
                    if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                        packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                        this.output.setStackInSlot(x, packet);
                        continue;
                    }
                    this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
            }
            this.func_70296_d();
        }
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> iStorageChannel) {
        return null;
    }

    public IConfigManager getConfigManager() {
        return null;
    }
}

