/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.util.DummyInvAdaptor;
import com.glodblock.github.util.MultiCraftingTracker;
import com.glodblock.github.util.Util;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;

public class TileFluidLevelMaintainer
extends AENetworkTile
implements ICraftingRequester,
IAEAppEngInventory,
ITickable {
    public EnumFacing facing;
    public static final int MAX_FLUID = 5;
    private int tick = 0;
    public boolean forceNextTick = false;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 5){

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return Integer.MAX_VALUE;
        }
    };
    private final MultiCraftingTracker craftingTracker = new MultiCraftingTracker(this, 5);
    private final long[] request = new long[5];
    private final IActionSource source;

    public TileFluidLevelMaintainer() {
        this.getProxy().setIdlePowerUsage(2.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
    }

    public void setConfig(int id, int size) {
        if (id < 0 || id >= 5 || this.config.getStackInSlot(id).func_190926_b()) {
            return;
        }
        ItemStack packet = this.config.getStackInSlot(id);
        FluidStack copy = (FluidStack)FakeItemRegister.getStack(packet);
        if (copy != null) {
            copy.amount = size;
        }
        this.config.setStackInSlot(id, FakeFluids.packFluid2Packet(copy));
        this.doWork();
    }

    public void setRequest(int id, long amount) {
        if (id < 0 || id >= 5 || amount < 0L) {
            return;
        }
        this.request[id] = amount;
        this.markForUpdate();
        this.doWork();
    }

    public IItemHandler getInventoryHandler() {
        return this.config;
    }

    public long[] getRequest() {
        return this.request;
    }

    @MENetworkEventSubscribe
    public void onStorageUpdate(MENetworkStorageEvent event) {
        if (event.channel.equals(Util.getFluidChannel())) {
            this.doWork();
        }
    }

    @MENetworkEventSubscribe
    public void onPowerUpdate(MENetworkPowerStatusChange event) {
        this.doWork();
    }

    @MENetworkEventSubscribe
    public void onChannelUpdate(MENetworkChannelsChanged event) {
        this.doWork();
    }

    public void doWork() {
        if (!this.getProxy().isActive()) {
            return;
        }
        IMEMonitor<IAEFluidStack> storage = this.getFluidMonitor();
        try {
            for (int i = 0; i < 5; ++i) {
                IAEFluidStack remain;
                IAEItemStack packet = this.config.getAEStackInSlot(i);
                FluidStack fluid = (FluidStack)FakeItemRegister.getStack(packet);
                if (fluid == null || fluid.amount <= 0 || (remain = (IAEFluidStack)storage.extractItems((IAEStack)AEFluidStack.fromFluidStack((FluidStack)fluid), Actionable.SIMULATE, this.source)) != null && remain.getStackSize() >= (long)fluid.amount) continue;
                FluidStack copy = fluid.copy();
                copy.amount = (int)this.request[i];
                this.craftingTracker.handleCrafting(i, this.request[i], FakeFluids.packFluid2AEDrops(copy), DummyInvAdaptor.INSTANCE, this.func_145831_w(), this.getProxy().getGrid(), this.getProxy().getCrafting(), this.source);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        int i;
        boolean changed = super.readFromStream(data);
        for (i = 0; i < this.config.getSlots(); ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)data);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.config.getStackInSlot(i))) continue;
            this.config.setStackInSlot(i, stack);
            changed = true;
        }
        for (i = 0; i < 5; ++i) {
            this.request[i] = data.readLong();
        }
        this.facing = EnumFacing.func_176731_b((int)data.readInt());
        return changed;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        int i;
        super.writeToStream(data);
        for (i = 0; i < this.config.getSlots(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.config.getStackInSlot(i));
        }
        for (i = 0; i < 5; ++i) {
            data.writeLong(this.request[i]);
        }
        if (this.facing != null) {
            data.writeInt(this.facing.func_176736_b());
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        for (int i = 0; i < 5; ++i) {
            this.request[i] = data.func_74763_f("reqX" + i);
        }
        this.config.readFromNBT(data, "configX");
        this.craftingTracker.readFromNBT(data);
        this.facing = data.func_74764_b("facing") ? EnumFacing.func_176731_b((int)data.func_74762_e("facing")) : EnumFacing.NORTH;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        for (int i = 0; i < 5; ++i) {
            data.func_74772_a("reqX" + i, this.request[i]);
        }
        this.config.writeToNBT(data, "configX");
        this.craftingTracker.writeToNBT(data);
        data.func_74768_a("facing", this.facing.func_176736_b());
        return data;
    }

    private IMEMonitor<IAEFluidStack> getFluidMonitor() {
        return ((IStorageGrid)this.getProxy().getNode().getGrid().getCache(IStorageGrid.class)).getInventory(Util.getFluidChannel());
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        IMEMonitor<IAEFluidStack> fluidGrid = this.getFluidMonitor();
        try {
            double power;
            IEnergyGrid energy;
            if (fluidGrid != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = (double)items.getStackSize() / 1000.0, mode, PowerMultiplier.CONFIG) > power - 0.01) {
                IAEFluidStack remaining;
                ItemStack inputStack = items.getCachedItemStack(items.getStackSize());
                FluidStack inputFluid = (FluidStack)FakeItemRegister.getStack(inputStack);
                if (mode == Actionable.SIMULATE) {
                    remaining = (IAEFluidStack)fluidGrid.injectItems((IAEStack)AEFluidStack.fromFluidStack((FluidStack)inputFluid), Actionable.SIMULATE, this.source);
                    items.setCachedItemStack(inputStack);
                } else {
                    remaining = (IAEFluidStack)fluidGrid.injectItems((IAEStack)AEFluidStack.fromFluidStack((FluidStack)inputFluid), Actionable.MODULATE, this.source);
                    if (remaining == null || remaining.getStackSize() <= 0L) {
                        ItemStack tmp = FakeFluids.packFluid2AEDrops(remaining) != null ? FakeFluids.packFluid2AEDrops(remaining).getDefinition() : null;
                        items.setCachedItemStack(tmp);
                    }
                }
                if (FakeFluids.packFluid2Drops(remaining != null ? remaining.getFluidStack() : null) == inputStack) {
                    return items;
                }
                return FakeFluids.packFluid2AEDrops(remaining);
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    public void onChangeInventory(IItemHandler iItemHandler, int i, InvOperation invOperation, ItemStack itemStack, ItemStack itemStack1) {
        this.markForUpdate();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ++this.tick;
            if (this.forceNextTick) {
                this.forceNextTick = false;
                this.doWork();
            } else if (this.tick > 1200) {
                this.tick = 0;
                this.doWork();
            }
        }
    }
}

