/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.me.cache.CraftingGridCache;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkTile;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class TileFluidDiscretizer
extends AENetworkTile
implements ICellContainer {
    private final FluidDiscretizingInventory fluidDropInv = new FluidDiscretizingInventory();
    private final FluidCraftingInventory fluidCraftInv = new FluidCraftingInventory();
    private final IActionSource ownActionSource = new MachineSource((IActionHost)this);
    private boolean prevActiveState = false;

    public TileFluidDiscretizer() {
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public boolean canBeRotated() {
        return false;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        try {
            if (this.getProxy().isActive() && this.getProxy().getGrid().getMachines(((Object)((Object)this)).getClass()).size() < 2) {
                if (channel == Util.getItemChannel()) {
                    return Collections.singletonList(this.fluidDropInv.invHandler);
                }
                if (channel == Util.getFluidChannel()) {
                    return Collections.singletonList(this.fluidCraftInv.invHandler);
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public void gridChanged() {
        IMEMonitor<IAEFluidStack> fluidGrid = this.getFluidGrid();
        if (fluidGrid != null) {
            fluidGrid.addListener((IMEMonitorHandlerReceiver)this.fluidDropInv, fluidGrid);
        }
    }

    @MENetworkEventSubscribe
    public void onPowerUpdate(MENetworkPowerStatusChange event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onChannelUpdate(MENetworkChannelsChanged event) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void onStorageUpdate(MENetworkStorageEvent event) {
        this.updateState();
    }

    private void updateState() {
        boolean isActive = this.getProxy().isActive();
        if (isActive != this.prevActiveState) {
            this.prevActiveState = isActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void blinkCell(int slot) {
    }

    @Nullable
    private IEnergyGrid getEnergyGrid() {
        try {
            return (IEnergyGrid)this.getProxy().getGrid().getCache(IEnergyGrid.class);
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    @Nullable
    private IMEMonitor<IAEFluidStack> getFluidGrid() {
        try {
            return ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(Util.getFluidChannel());
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    private class FluidCraftingInventory
    implements IMEInventory {
        private final MEInventoryHandler invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());

        FluidCraftingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        @Nullable
        public IAEStack injectItems(IAEStack aeStack, Actionable type, IActionSource src) {
            IAEItemStack remaining;
            ICraftingGrid craftingGrid;
            if (!(aeStack instanceof IAEFluidStack)) {
                return null;
            }
            IAEFluidStack input = (IAEFluidStack)aeStack;
            try {
                craftingGrid = (ICraftingGrid)TileFluidDiscretizer.this.getProxy().getGrid().getCache(ICraftingGrid.class);
            }
            catch (GridAccessException e) {
                return null;
            }
            if (craftingGrid instanceof CraftingGridCache && (remaining = ((CraftingGridCache)craftingGrid).injectItems(FakeFluids.packFluid2AEDrops(input), type, TileFluidDiscretizer.this.ownActionSource)) != null) {
                return (IAEStack)FakeItemRegister.getAEStack(remaining);
            }
            return null;
        }

        @Nullable
        public IAEStack extractItems(IAEStack request, Actionable mode, IActionSource src) {
            return null;
        }

        public IItemList getAvailableItems(IItemList out) {
            return out;
        }

        public IStorageChannel<IAEFluidStack> getChannel() {
            return Util.getFluidChannel();
        }
    }

    private class FluidDiscretizingInventory
    implements IMEInventory<IAEItemStack>,
    IMEMonitorHandlerReceiver<IAEFluidStack> {
        private final MEInventoryHandler<IAEItemStack> invHandler = new MEInventoryHandler((IMEInventory)this, this.getChannel());
        @Nullable
        private ObjectArrayList<IAEItemStack> itemCache = null;

        FluidDiscretizingInventory() {
            this.invHandler.setPriority(Integer.MAX_VALUE);
        }

        @Nullable
        public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
            Object fluidStack = FakeItemRegister.getAEStack(request);
            if (!(fluidStack instanceof IAEFluidStack)) {
                return null;
            }
            IMEMonitor fluidGrid = TileFluidDiscretizer.this.getFluidGrid();
            if (fluidGrid == null) {
                return null;
            }
            IEnergyGrid energyGrid = TileFluidDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return null;
            }
            return FakeFluids.packFluid2AEDrops((IAEFluidStack)fluidGrid.extractItems((IAEStack)((IAEFluidStack)fluidStack), mode, TileFluidDiscretizer.this.ownActionSource));
        }

        @Nullable
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
            Object fluidStack = FakeItemRegister.getAEStack(input);
            if (!(fluidStack instanceof IAEFluidStack)) {
                return input;
            }
            IMEMonitor fluidGrid = TileFluidDiscretizer.this.getFluidGrid();
            if (fluidGrid == null) {
                return input;
            }
            IEnergyGrid energyGrid = TileFluidDiscretizer.this.getEnergyGrid();
            if (energyGrid == null) {
                return input;
            }
            return FakeFluids.packFluid2AEDrops((IAEFluidStack)fluidGrid.injectItems((IAEStack)((IAEFluidStack)fluidStack), type, TileFluidDiscretizer.this.ownActionSource));
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            if (this.itemCache == null) {
                this.itemCache = new ObjectArrayList();
                IMEMonitor fluidGrid = TileFluidDiscretizer.this.getFluidGrid();
                if (fluidGrid != null) {
                    for (IAEFluidStack fluid : fluidGrid.getStorageList()) {
                        IAEItemStack stack = FakeFluids.packFluid2AEDrops(fluid);
                        if (stack == null) continue;
                        this.itemCache.add((Object)stack);
                    }
                }
            }
            for (IAEItemStack stack : this.itemCache) {
                out.addStorage((IAEStack)stack);
            }
            return out;
        }

        public boolean isValid(Object verificationToken) {
            IMEMonitor fluidGrid = TileFluidDiscretizer.this.getFluidGrid();
            return fluidGrid != null && fluidGrid == verificationToken;
        }

        public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
            this.itemCache = null;
            try {
                ObjectArrayList mappedChanges = new ObjectArrayList();
                for (IAEFluidStack fluidStack : change) {
                    IAEItemStack itemStack;
                    boolean isNg = false;
                    if (fluidStack.getStackSize() < 0L) {
                        isNg = true;
                        fluidStack.setStackSize(-fluidStack.getStackSize());
                    }
                    if ((itemStack = FakeFluids.packFluid2AEDrops(fluidStack)) == null) continue;
                    if (isNg) {
                        itemStack.setStackSize(-itemStack.getStackSize());
                    }
                    mappedChanges.add((Object)itemStack);
                }
                ((IStorageGrid)TileFluidDiscretizer.this.getProxy().getGrid().getCache(IStorageGrid.class)).postAlterationOfStoredItems(this.getChannel(), (Iterable)mappedChanges, TileFluidDiscretizer.this.ownActionSource);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }

        public void onListUpdate() {
        }

        public IStorageChannel<IAEItemStack> getChannel() {
            return Util.getItemChannel();
        }
    }
}

