/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidCraftEncodedPattern;
import com.glodblock.github.util.FluidCraftingPatternDetails;
import com.glodblock.github.util.Util;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileFluidAssembler
extends AENetworkInvTile
implements ICraftingProvider,
ITickable {
    public final AppEngInternalInventory invPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, 36, 1);
    public final AppEngInternalInventory upgrade = new AppEngInternalInventory((IAEAppEngInventory)this, 2, 3);
    public final AppEngInternalInventory gridInv = new AppEngInternalInventory((IAEAppEngInventory)this, 9, 1);
    public final AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private ObjectArrayList<ICraftingPatternDetails> craftingList = null;
    private int progress = 0;
    private static final double powerUsage = 0.5;
    public static final int TIME = 20;
    private ICraftingPatternDetails myPlan = null;
    private final IActionSource mySrc = new MachineSource((IActionHost)this);
    private ObjectArrayList<ItemStack> waitingToSend = new ObjectArrayList();

    public TileFluidAssembler() {
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.notifyNeighbors();
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        if (is.func_77973_b() instanceof ItemFluidCraftEncodedPattern && (details = ((ItemFluidCraftEncodedPattern)is.func_77973_b()).getPatternForItem(is, this.func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new ObjectArrayList();
            }
            this.craftingList.add((Object)details);
        }
    }

    private void updateCraftingList() {
        Object[] accountedFor = new Boolean[this.invPatterns.getSlots()];
        Arrays.fill(accountedFor, (Object)false);
        if (!this.getProxy().isReady()) {
            return;
        }
        if (this.craftingList != null) {
            ObjectListIterator i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = (ICraftingPatternDetails)i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.invPatterns.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.addToCraftingList(this.invPatterns.getStackInSlot(x));
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    public void onReady() {
        super.onReady();
        this.updateCraftingList();
    }

    @Nonnull
    public IItemHandler getInternalInventory() {
        return this.invPatterns;
    }

    public boolean canBeRotated() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invPatterns;
        }
        return null;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(inv != this.invPatterns || removed.func_190926_b() && added.func_190926_b())) {
            this.updateCraftingList();
        }
        this.markForUpdate();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.upgrade.writeToNBT(data, "upgrade");
        this.gridInv.writeToNBT(data, "gridInv");
        this.output.writeToNBT(data, "output");
        data.func_74768_a("progress", this.progress);
        if (this.myPlan != null) {
            ItemStack pattern = this.myPlan.getPattern();
            NBTTagCompound tmp = new NBTTagCompound();
            pattern.func_77955_b(tmp);
            data.func_74782_a("myPlan", (NBTBase)tmp);
        }
        NBTTagList waitingToSend = new NBTTagList();
        if (!this.waitingToSend.isEmpty()) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound item = new NBTTagCompound();
                is.func_77955_b(item);
                waitingToSend.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.upgrade.readFromNBT(data, "upgrade");
        this.gridInv.readFromNBT(data, "gridInv");
        this.output.readFromNBT(data, "output");
        this.progress = data.func_74762_e("progress");
        if (data.func_74764_b("myPlan")) {
            ItemStack pattern = new ItemStack(data.func_74775_l("myPlan"));
            this.myPlan = FluidCraftingPatternDetails.GetFluidPattern(pattern, this.func_145831_w());
        }
        this.waitingToSend = new ObjectArrayList();
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        for (int x = 0; x < waitingList.func_74745_c(); ++x) {
            NBTTagCompound c = waitingList.func_150305_b(x);
            this.waitingToSend.add((Object)new ItemStack(c));
        }
        this.updateCraftingList();
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getProxy().isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting inventoryCrafting) {
        if (!(this.getProxy().isActive() && this.myPlan == null && this.craftingList.contains((Object)patternDetails) && patternDetails instanceof FluidCraftingPatternDetails)) {
            return false;
        }
        FluidCraftingPatternDetails fluidPattern = (FluidCraftingPatternDetails)patternDetails;
        this.myPlan = patternDetails;
        for (int x = 0; x < 9; ++x) {
            IAEItemStack item = fluidPattern.getOriginInputs()[x];
            if (item == null) {
                this.gridInv.setStackInSlot(x, ItemStack.field_190927_a);
                continue;
            }
            this.gridInv.setStackInSlot(x, item.getDefinition());
        }
        if (fluidPattern.getOutputs()[0] != null) {
            this.output.setStackInSlot(0, fluidPattern.getOutputs()[0].getDefinition());
        } else {
            this.output.setStackInSlot(0, ItemStack.field_190927_a);
        }
        return true;
    }

    public boolean isBusy() {
        return this.myPlan != null || !this.waitingToSend.isEmpty() || this.progress > 0;
    }

    public int getSpeed() {
        Upgrades type;
        ItemStack card = this.upgrade.getStackInSlot(0);
        if (!card.func_190926_b() && card.func_77973_b() instanceof IUpgradeModule && (type = ((IUpgradeModule)card.func_77973_b()).getType(card)) == Upgrades.SPEED) {
            return card.func_190916_E() + 1;
        }
        return 1;
    }

    public int getPatternCap() {
        Upgrades type;
        ItemStack card = this.upgrade.getStackInSlot(1);
        if (!card.func_190926_b() && card.func_77973_b() instanceof IUpgradeModule && (type = ((IUpgradeModule)card.func_77973_b()).getType(card)) == Upgrades.PATTERN_EXPANSION) {
            return card.func_190916_E();
        }
        return 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L) {
            if (this.waitingToSend.isEmpty()) {
                int speed = this.getSpeed();
                if (this.myPlan != null && this.drainEnergy(0.5 * (double)speed)) {
                    this.progress += speed;
                    if (this.progress >= 20) {
                        int x;
                        IAEItemStack[] outputs;
                        this.progress = 0;
                        for (IAEItemStack item : outputs = this.myPlan.getOutputs()) {
                            this.waitingToSend.add((Object)item.createItemStack());
                        }
                        for (x = 0; x < this.gridInv.getSlots(); ++x) {
                            this.gridInv.setStackInSlot(x, ItemStack.field_190927_a);
                        }
                        for (x = 0; x < this.output.getSlots(); ++x) {
                            this.output.setStackInSlot(x, ItemStack.field_190927_a);
                        }
                        this.myPlan = null;
                    }
                }
            }
            if (!this.waitingToSend.isEmpty() && this.getProxy().isActive()) {
                ObjectArrayList rst = new ObjectArrayList();
                try {
                    IMEMonitor des = this.getProxy().getStorage().getInventory(Util.getItemChannel());
                    IEnergyGrid src = this.getProxy().getEnergy();
                    for (ItemStack item : this.waitingToSend) {
                        IAEItemStack remaining;
                        if (item == null || item.func_190926_b() || (remaining = (IAEItemStack)Platform.poweredInsert((IEnergySource)src, (IMEInventory)des, (IAEStack)((IAEStack)Objects.requireNonNull(AEItemStack.fromItemStack((ItemStack)item))), (IActionSource)this.mySrc)) == null) continue;
                        rst.add((Object)remaining.createItemStack());
                    }
                    this.waitingToSend = rst;
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean drainEnergy(double energy) {
        double drain = 0.0;
        try {
            IGrid grid = this.getProxy().getGrid();
            if (grid != null) {
                IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                drain = energyGrid.extractAEPower(energy, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return drain > 0.0;
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (!this.waitingToSend.isEmpty()) {
            drops.addAll((Collection<ItemStack>)this.waitingToSend);
        }
        for (ItemStack item : this.invPatterns) {
            if (item == null || item.func_190926_b()) continue;
            drops.add(item);
        }
        for (ItemStack item : this.upgrade) {
            if (item == null || item.func_190926_b()) continue;
            drops.add(item);
        }
    }

    public void dropExcessPatterns() {
        ObjectArrayList dropList = new ObjectArrayList();
        for (int invSlot = 0; invSlot < this.invPatterns.getSlots(); ++invSlot) {
            ItemStack is;
            if (invSlot <= 8 + this.getPatternCap() * 9 || (is = this.invPatterns.getStackInSlot(invSlot)).func_190926_b()) continue;
            dropList.add((Object)this.invPatterns.extractItem(invSlot, Integer.MAX_VALUE, false));
        }
        if (dropList.size() > 0) {
            World world = this.getLocation().getWorld();
            BlockPos blockPos = this.getLocation().getPos();
            Platform.spawnDrops((World)world, (BlockPos)blockPos, (List)dropList);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void notifyNeighbors() {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        Platform.notifyBlocksOfNeighbors((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.progress);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean changed = super.readFromStream(data);
        int newPro = data.readInt();
        if (this.progress != newPro) {
            this.progress = newPro;
            changed = true;
        }
        return changed;
    }
}

