/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.part;

import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.items.parts.PartModels;
import appeng.parts.PartBasicState;
import appeng.parts.PartModel;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.component.DualityDualInterface;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.interfaces.FCPriorityHost;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.loader.FCItems;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class PartDualInterface
extends PartBasicState
implements IGridTickable,
IInventoryDestination,
IInterfaceHost,
IAEAppEngInventory,
FCPriorityHost,
IFluidInterfaceHost {
    @PartModels
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("ae2fc", "part/interface_base"), new ResourceLocation("ae2fc", "part/interface_on"), new ResourceLocation("ae2fc", "part/interface_off"), new ResourceLocation("ae2fc", "part/interface_has_channel")};
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS[0], MODELS[2]});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS[0], MODELS[1]});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS[0], MODELS[3]});
    protected final DualityDualInterface<PartDualInterface> duality = this.createDuality();

    public PartDualInterface(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.onChannelStateChange(c);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.onPowerStateChange(c);
    }

    protected DualityDualInterface createDuality() {
        return new DualityDualInterface<PartDualInterface>(this.getProxy(), this);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    public void gridChanged() {
        this.duality.onGridChanged();
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.duality.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.duality.writeToNBT(data);
    }

    public void addToWorld() {
        super.addToWorld();
        this.duality.initialize();
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        this.duality.addDrops(drops);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    public IItemHandler getInventoryByName(String name) {
        return this.duality.getItemInventoryByName(name);
    }

    public boolean onPartActivate(EntityPlayer p, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            TileEntity tile = this.getTileEntity();
            InventoryHandler.openGui(p, tile.func_145831_w(), tile.func_174877_v(), this.getSide().getFacing(), GuiType.DUAL_ITEM_INTERFACE);
        }
        return true;
    }

    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsertItem(stack);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.duality.onTick(node, ticksSinceLastCall);
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.duality.onItemInventoryChange(inv, slot, mc, removedStack, newStack);
    }

    public void onStackReturnNetwork(IAEFluidStack stack) {
        this.duality.getItemInterface().onStackReturnedToNetwork(FakeFluids.packFluid2AEDrops(stack));
    }

    public void onStackReturnNetwork(IAEItemStack stack) {
        this.duality.getItemInterface().onStackReturnedToNetwork(stack);
    }

    public DualityInterface getInterfaceDuality() {
        return this.duality.getItemInterface();
    }

    public DualityFluidInterface getDualityFluidInterface() {
        return this.duality.getFluidInterface();
    }

    public EnumSet<EnumFacing> getTargets() {
        return EnumSet.of(this.getSide().getFacing());
    }

    public TileEntity getTileEntity() {
        return super.getHost().getTile();
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    public boolean isBusy() {
        return this.duality.isCraftingBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestCraftingJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    public void jobStateChange(ICraftingLink link) {
        this.duality.onCraftingJobStateChange(link);
    }

    public int getPriority() {
        return this.duality.getPriority();
    }

    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        return this.duality.hasCapability(capabilityClass, this.getSide().getFacing());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capabilityClass) {
        return this.duality.getCapability(capabilityClass, this.getSide().getFacing());
    }

    @Override
    public GuiType getGuiType() {
        return GuiType.DUAL_ITEM_INTERFACE;
    }

    public ItemStack getItemStackRepresentation() {
        return new ItemStack((Item)FCItems.PART_DUAL_INTERFACE, 1);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        NBTTagCompound pre = super.downloadSettings(from);
        NBTTagCompound tag = pre == null ? new NBTTagCompound() : pre;
        tag.func_74782_a("pattern", (NBTBase)this.duality.downloadSettings(from));
        return tag.func_82582_d() ? null : tag;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        super.uploadSettings(from, compound, player);
        if (compound.func_74764_b("pattern")) {
            this.duality.uploadSettings(compound.func_74775_l("pattern"), player);
        }
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity = this.getTileEntity();
        if (tileEntity instanceof IInterfaceHost) {
            ((IInterfaceHost)tileEntity).getInterfaceDuality().updateRedstoneState();
        }
    }
}

