/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.StackSizeRenderer;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderUtils {
    @Nullable
    public static TextureAtlasSprite prepareRender(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill(fluidStack).toString());
        int colour = fluid.getColor(fluidStack);
        GlStateManager.func_179131_c((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)((float)(colour >> 24 & 0xFF) / 255.0f));
        return sprite;
    }

    public static void doRenderFluid(Tessellator tess, BufferBuilder buf, int x, int y, int width, int height, TextureAtlasSprite sprite, double fraction) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int fluidHeight = Math.round((float)height * (float)Math.min(1.0, Math.max(0.0, fraction)));
        double x2 = x + width;
        while (fluidHeight > 0) {
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double y1 = y + height - fluidHeight;
            double y2 = y1 + (double)Math.min(fluidHeight, width);
            double u1 = sprite.func_94209_e();
            double v1 = sprite.func_94206_g();
            double u2 = sprite.func_94212_f();
            double v2 = sprite.func_94210_h();
            if (fluidHeight < width) {
                v2 = v1 + (v2 - v1) * ((double)fluidHeight / (double)width);
                fluidHeight = 0;
            } else {
                fluidHeight -= width;
            }
            buf.func_181662_b((double)x, y1, 0.0).func_187315_a(u1, v1).func_181675_d();
            buf.func_181662_b((double)x, y2, 0.0).func_187315_a(u1, v2).func_181675_d();
            buf.func_181662_b(x2, y2, 0.0).func_187315_a(u2, v2).func_181675_d();
            buf.func_181662_b(x2, y1, 0.0).func_187315_a(u2, v1).func_181675_d();
            tess.func_78381_a();
        }
        GlStateManager.func_179084_k();
    }

    public static void renderFluidIntoGui(Tessellator tess, BufferBuilder buf, int x, int y, int width, int height, @Nullable IAEFluidStack aeFluidStack, int capacity) {
        TextureAtlasSprite sprite;
        if (aeFluidStack != null && (sprite = FluidRenderUtils.prepareRender(aeFluidStack.getFluidStack())) != null) {
            FluidRenderUtils.doRenderFluid(tess, buf, x, y, width, height, sprite, (double)aeFluidStack.getStackSize() / (double)capacity);
        }
    }

    public static void renderFluidIntoGui(Tessellator tess, BufferBuilder buf, int x, int y, int width, int height, @Nullable FluidStack fluidStack, int capacity) {
        TextureAtlasSprite sprite;
        if (fluidStack != null && (sprite = FluidRenderUtils.prepareRender(fluidStack)) != null) {
            FluidRenderUtils.doRenderFluid(tess, buf, x, y, width, height, sprite, (double)fluidStack.amount / (double)capacity);
        }
    }

    public static void renderFluidIntoGuiCleanly(int x, int y, int width, int height, @Nullable IAEFluidStack aeFluidStack, int capacity) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tess = Tessellator.func_178181_a();
        FluidRenderUtils.renderFluidIntoGui(tess, tess.func_178180_c(), x, y, width, height, aeFluidStack, capacity);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderFluidIntoGuiCleanly(int x, int y, int width, int height, @Nullable FluidStack fluidStack, int capacity) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tess = Tessellator.func_178181_a();
        FluidRenderUtils.renderFluidIntoGui(tess, tess.func_178180_c(), x, y, width, height, fluidStack, capacity);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean renderFluidIntoGuiSlot(Slot slot, @Nullable FluidStack fluid, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        if (fluid == null || fluid.amount <= 0) {
            return false;
        }
        FluidRenderUtils.renderFluidIntoGuiCleanly(slot.field_75223_e, slot.field_75221_f, 16, 16, fluid, fluid.amount);
        stackSizeRenderer.renderStackSize(fontRenderer, FakeFluids.packFluid2AEDrops(fluid), slot.field_75223_e, slot.field_75221_f);
        return true;
    }

    public static boolean renderFluidPacketIntoGuiSlot(Slot slot, @Nullable IAEItemStack stack, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        return stack != null && stack.getItem() instanceof ItemFluidPacket && FluidRenderUtils.renderFluidIntoGuiSlot(slot, (FluidStack)FakeItemRegister.getStack(stack), stackSizeRenderer, fontRenderer);
    }

    public static boolean renderFluidPacketIntoGuiSlot(Slot slot, ItemStack stack, StackSizeRenderer stackSizeRenderer, FontRenderer fontRenderer) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemFluidPacket && FluidRenderUtils.renderFluidIntoGuiSlot(slot, (FluidStack)FakeItemRegister.getStack(stack), stackSizeRenderer, fontRenderer);
    }
}

