/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render;

import com.glodblock.github.util.ModAndClassUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DropColourHandler {
    private final Map<String, Integer> colourCache = new HashMap<String, Integer>();

    @SubscribeEvent
    public void onTextureMapStitch(TextureStitchEvent event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            this.colourCache.clear();
        }
    }

    public int getColour(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        int colour = fluid.getColor(fluidStack);
        if (ModAndClassUtil.GT && colour == -1) {
            return this.runBidAidFix(fluidStack);
        }
        return colour != -1 ? colour : this.getColour(fluid);
    }

    public int getColour(Fluid fluid) {
        TextureAtlasSprite sprite;
        Integer cached = this.colourCache.get(fluid.getName());
        if (cached != null) {
            return cached;
        }
        int colour = fluid.getColor();
        if (colour == -1 && (sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill().toString())) != null && sprite.func_110970_k() > 0) {
            int[][] image = sprite.func_147965_a(0);
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            int[][] nArray = image;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int pixel : row = nArray[i]) {
                    if ((pixel >> 24 & 0xFF) <= 127) continue;
                    r += pixel >> 16 & 0xFF;
                    g += pixel >> 8 & 0xFF;
                    b += pixel & 0xFF;
                    ++count;
                }
            }
            if (count > 0) {
                colour = r / count << 16 | g / count << 8 | b / count;
            }
        }
        this.colourCache.put(fluid.getName(), colour);
        return colour;
    }

    private int runBidAidFix(FluidStack fluidStack) {
        if (fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"helium", (int)1))) {
            return -196720;
        }
        return this.getColour(fluidStack.getFluid());
    }
}

