/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.model;

import com.glodblock.github.client.model.FluidPacketModel;
import com.glodblock.github.common.item.ItemGasPacket;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.util.NameConst;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.MekanismFluids;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class GasPacketModel
extends FluidPacketModel {
    @Override
    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureBakery) {
        return new BakedGasPacketModel(state, format);
    }

    protected static class BakedGasPacketModel
    extends FluidPacketModel.BakedFluidPacketModel {
        public BakedGasPacketModel(IModelState modelState, VertexFormat vertexFormat) {
            super(modelState, vertexFormat);
        }

        @Override
        protected OverrideCache genOverrides() {
            return new OverrideCache();
        }

        @Override
        protected OverrideCache.OverrideModel genDefaultOverrides() {
            return ((OverrideCache)this.overrides).resolve(new GasStack(MekanismFluids.Hydrogen, 1000));
        }

        protected class OverrideCache
        extends ItemOverrideList {
            private final Cache<Gas, OverrideModel> cache;

            OverrideCache() {
                super(Collections.emptyList());
                this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
            }

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (!(stack.func_77973_b() instanceof ItemGasPacket)) {
                    return originalModel;
                }
                GasStack gas = (GasStack)FakeItemRegister.getStack(stack);
                return gas != null ? this.resolve(gas) : originalModel;
            }

            OverrideModel resolve(GasStack gas) {
                try {
                    return (OverrideModel)this.cache.get((Object)gas.getGas(), () -> new OverrideModel(gas));
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }

            class OverrideModel
            implements IBakedModel {
                private final TextureAtlasSprite texture;
                private final List<BakedQuad> quads;

                OverrideModel(GasStack gasStack) {
                    this.texture = gasStack.getGas().getSprite();
                    this.quads = ItemLayerModel.getQuadsForSprite((int)1, (TextureAtlasSprite)this.texture, (VertexFormat)BakedGasPacketModel.this.vertexFormat, (Optional)BakedGasPacketModel.this.modelTransform);
                }

                @Nonnull
                public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                    return this.quads;
                }

                public boolean func_177555_b() {
                    return false;
                }

                public boolean func_177556_c() {
                    return false;
                }

                public boolean func_188618_c() {
                    return false;
                }

                @Nonnull
                public TextureAtlasSprite func_177554_e() {
                    return this.texture;
                }

                @Nonnull
                public ItemCameraTransforms func_177552_f() {
                    return FluidPacketModel.CAMERA_TRANSFORMS;
                }

                @Nonnull
                public ItemOverrideList func_188617_f() {
                    return OverrideCache.this;
                }
            }
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.compareTo(NameConst.MODEL_GAS_PACKET) == 0;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return new GasPacketModel();
        }
    }
}

