/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.model;

import com.glodblock.github.FluidCraft;
import com.glodblock.github.util.Ae2ReflectClient;
import com.glodblock.github.util.NameConst;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class DenseCraftEncodedPatternModel
implements IModel {
    private static final ResourceLocation BASE_MODEL = FluidCraft.resource("item/dense_craft_encoded_pattern");

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(BASE_MODEL);
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseModel;
        try {
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)BASE_MODEL).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Ae2ReflectClient.bakeEncodedPatternModel(baseModel, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
    }

    public static class Loader
    implements ICustomModelLoader {
        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.compareTo(NameConst.MODEL_DENSE_CRAFT_ENCODED_PATTERN) == 0;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return new DenseCraftEncodedPatternModel();
        }
    }
}

