/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidCraftEncodedPattern;
import com.glodblock.github.common.tile.TileFluidAssembler;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerFluidAssembler
extends AEBaseContainer
implements IOptionalSlotHost,
IProgressProvider {
    private final TileFluidAssembler tile;
    @GuiSync(value=1)
    public int patternCap = 0;
    @GuiSync(value=2)
    public int progress = 0;

    public ContainerFluidAssembler(InventoryPlayer ipl, TileFluidAssembler tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        for (int row = 0; row < 4; ++row) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new CraftPattern((IItemHandler)tile.invPatterns, this, x + row * 9, 8 + 18 * x, 83 + 18 * row, row, this.getInventoryPlayer()).setStackLimit(1));
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new FakeDisplaySlot((IItemHandler)tile.gridInv, j + i * 3, 29 + j * 18, 16 + i * 18));
            }
        }
        this.func_75146_a((Slot)new FakeDisplaySlot((IItemHandler)tile.output, 0, 126, 35));
        this.func_75146_a((Slot)new FilterSlot((ItemStack)AEApi.instance().definitions().materials().cardSpeed().maybeStack(1).get(), (IItemHandler)tile.upgrade, 0, 134, 61));
        this.func_75146_a((Slot)new FilterSlot((ItemStack)AEApi.instance().definitions().materials().cardPatternExpansion().maybeStack(1).get(), (IItemHandler)tile.upgrade, 1, 152, 61));
        this.bindPlayerInventory(ipl, 0, 167);
    }

    public boolean isSlotEnabled(int i) {
        return this.tile.getPatternCap() >= i;
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.patternCap != this.tile.getPatternCap()) {
            this.patternCap = this.tile.getPatternCap();
            this.tile.dropExcessPatterns();
        }
        if (Platform.isServer()) {
            this.progress = this.tile.getProgress();
        }
        super.func_75142_b();
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("patternCap")) {
            this.tile.dropExcessPatterns();
        }
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 20;
    }

    static class FakeDisplaySlot
    extends AppEngSlot {
        public FakeDisplaySlot(IItemHandler inv, int idx, int x, int y) {
            super(inv, idx, x, y);
        }

        @Nonnull
        public ItemStack func_190901_a(@Nonnull EntityPlayer par1EntityPlayer, @Nonnull ItemStack par2ItemStack) {
            return par2ItemStack;
        }

        @Nonnull
        public ItemStack func_75209_a(int par1) {
            return ItemStack.field_190927_a;
        }

        public boolean func_75214_a(@Nonnull ItemStack par1ItemStack) {
            return false;
        }

        public void func_75215_d(ItemStack is) {
            if (!is.func_190926_b()) {
                is = is.func_77946_l();
            }
            super.func_75215_d(is);
        }

        public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
            return false;
        }
    }

    static class FilterSlot
    extends AppEngSlot {
        private final ItemStack filter;

        public FilterSlot(ItemStack filter, IItemHandler i, int slotIndex, int x, int y) {
            super(i, slotIndex, x, y);
            this.filter = filter;
        }

        public boolean func_75214_a(@Nonnull ItemStack i) {
            if (!this.getContainer().isValidForSlot((Slot)this, i)) {
                return false;
            }
            if (i.func_190926_b()) {
                return false;
            }
            if (i.func_77973_b() == Items.field_190931_a) {
                return false;
            }
            if (!super.func_75214_a(i)) {
                return false;
            }
            return this.filter.func_77969_a(i);
        }
    }

    static class CraftPattern
    extends OptionalSlotRestrictedInput {
        public CraftPattern(IItemHandler i, IOptionalSlotHost host, int slotIndex, int x, int y, int grpNum, InventoryPlayer invPlayer) {
            super(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, i, host, slotIndex, x, y, grpNum, invPlayer);
        }

        public boolean func_75214_a(ItemStack i) {
            if (!this.getContainer().isValidForSlot((Slot)this, i)) {
                return false;
            }
            if (i.func_190926_b()) {
                return false;
            }
            if (i.func_77973_b() == Items.field_190931_a) {
                return false;
            }
            if (!super.func_75214_a(i)) {
                return false;
            }
            return i.func_77973_b() instanceof ItemFluidCraftEncodedPattern;
        }
    }
}

