/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerExpandedProcessingPatternTerm;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.ItemLargeEncodedPattern;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.part.PartExtendedFluidPatternTerminal;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.interfaces.PatternConsumer;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerExtendedFluidPatternTerminal
extends ContainerExpandedProcessingPatternTerm
implements PatternConsumer {
    public final ITerminalHost part;
    @GuiSync(value=105)
    public boolean combine = false;
    @GuiSync(value=106)
    public boolean fluidFirst = false;

    public ContainerExtendedFluidPatternTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.part = monitorable;
        this.craftingMode = false;
    }

    public void encode() {
        if (!this.checkHasFluidPattern()) {
            super.encode();
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack.func_190926_b()) {
            stack = this.patternSlotIN.func_75211_c();
            if (stack.func_190926_b() || !ContainerExtendedFluidPatternTerminal.isPattern(stack)) {
                return;
            }
            if (stack.func_190916_E() == 1) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            } else {
                stack.func_190918_g(1);
            }
            this.encodeFluidPattern();
        } else if (ContainerExtendedFluidPatternTerminal.isPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    private static boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return true;
        }
        if (output.func_77973_b() instanceof ItemLargeEncodedPattern) {
            return true;
        }
        IDefinitions defs = AEApi.instance().definitions();
        return defs.items().encodedPattern().isSameAs(output) || defs.materials().blankPattern().isSameAs(output);
    }

    private boolean checkHasFluidPattern() {
        boolean hasFluid = false;
        boolean search = false;
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            ItemStack crafting = slotFakeCraftingMatrix.func_75211_c();
            if (crafting.func_190926_b()) continue;
            search = true;
            if (crafting.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || crafting.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        if (!search) {
            return false;
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            ItemStack out = slotFakeCraftingMatrix.func_75211_c();
            if (out.func_190926_b()) continue;
            search = false;
            if (hasFluid) break;
            if (out.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || out.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        return hasFluid && !search;
    }

    private void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)FCItems.DENSE_ENCODED_PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(ContainerExtendedFluidPatternTerminal.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(ContainerExtendedFluidPatternTerminal.collectInventory((Slot[])this.outputSlots));
        pattern.setEncoder(this.getInventoryPlayer().field_70458_d.func_146103_bH());
        this.patternSlotOUT.func_75215_d(pattern.writeToStack());
    }

    private static IAEItemStack[] collectInventory(Slot[] slots) {
        ArrayList<Object> acc = new ArrayList<Object>();
        for (Slot slot : slots) {
            IAEItemStack dropStack;
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == FCItems.FLUID_PACKET && (dropStack = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            if (ModAndClassUtil.GAS && stack.func_77973_b() == FCGasItems.GAS_PACKET && (dropStack = FakeGases.packGas2AEDrops((GasStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
            if (aeStack == null) continue;
            acc.add(aeStack);
        }
        return acc.toArray(new IAEItemStack[0]);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        if (slotId < 0 || slotId >= this.field_75151_b.size()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        Slot slot = this.func_75139_a(slotId);
        ItemStack stack = player.field_71071_by.func_70445_o();
        if ((slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && Util.getFluidFromItem(stack) != null) {
            FluidStack fluid = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    fluid = Util.getFluidFromItem(stack);
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    fluid = Util.getFluidFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    FluidStack origin = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (fluid != null && fluid.equals((Object)origin)) {
                        fluid.amount += origin.amount;
                        if (fluid.amount <= 0) {
                            fluid = null;
                        }
                    }
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            }
            if (fluid == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (ModAndClassUtil.GAS && (slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null) && Util.getGasFromItem(stack) != null) {
            GasStack gas = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    gas = (GasStack)Util.getGasFromItem(stack);
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    gas = (GasStack)Util.getGasFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    GasStack origin = (GasStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (gas != null && gas.equals(origin)) {
                        gas.amount += origin.amount;
                        if (gas.amount <= 0) {
                            gas = null;
                        }
                    }
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                }
            }
            if (gas == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE) {
            GasStack gas;
            if (stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() instanceof ItemFluidPacket) {
                FluidStack fluid = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                if (fluid != null && fluid.amount - 1000 >= 1) {
                    fluid.amount -= 1000;
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            } else if (ModAndClassUtil.GAS && stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() == FCGasItems.GAS_PACKET && (gas = (GasStack)FakeItemRegister.getStack(slot.func_75211_c())) != null && gas.amount - 1000 >= 1) {
                gas.amount -= 1000;
                slot.func_75215_d(FakeGases.packGas2Packet(gas));
            }
        }
        super.doAction(player, action, slotId, id);
    }

    public void multiply(int multiple) {
        if (Util.multiplySlotCheck((Slot[])this.craftingSlots, multiple) && Util.multiplySlotCheck((Slot[])this.outputSlots, multiple)) {
            Util.multiplySlot((Slot[])this.craftingSlots, multiple);
            Util.multiplySlot((Slot[])this.outputSlots, multiple);
        }
    }

    public void divide(int divide) {
        if (Util.divideSlotCheck((Slot[])this.craftingSlots, divide) && Util.divideSlotCheck((Slot[])this.outputSlots, divide)) {
            Util.divideSlot((Slot[])this.craftingSlots, divide);
            Util.divideSlot((Slot[])this.outputSlots, divide);
        }
    }

    public void increase(int increase) {
        if (Util.increaseSlotCheck((Slot[])this.craftingSlots, increase) && Util.increaseSlotCheck((Slot[])this.outputSlots, increase)) {
            Util.increaseSlot((Slot[])this.craftingSlots, increase);
            Util.increaseSlot((Slot[])this.outputSlots, increase);
        }
    }

    public void decrease(int decrease) {
        if (Util.decreaseSlotCheck((Slot[])this.craftingSlots, decrease) && Util.decreaseSlotCheck((Slot[])this.outputSlots, decrease)) {
            Util.decreaseSlot((Slot[])this.craftingSlots, decrease);
            Util.decreaseSlot((Slot[])this.outputSlots, decrease);
        }
    }

    @Override
    public void acceptPattern(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        if (this.part instanceof PartExtendedFluidPatternTerminal) {
            ((PartExtendedFluidPatternTerminal)this.part).onChangeCrafting(inputs, outputs, combine);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.combine = ((PartExtendedFluidPatternTerminal)Ae2Reflect.getPart((ContainerPatternEncoder)this)).getCombineMode();
            this.fluidFirst = ((PartExtendedFluidPatternTerminal)Ae2Reflect.getPart((ContainerPatternEncoder)this)).getFluidPlaceMode();
        }
    }
}

