/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.storage.data.IAEFluidStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotNormal;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import com.glodblock.github.common.tile.TileBurette;
import com.glodblock.github.interfaces.TankDumpable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class ContainerBurette
extends AEBaseContainer
implements IFluidSyncContainer,
TankDumpable {
    private final TileBurette tile;
    private final FluidSyncHelper fluidSync;

    public ContainerBurette(InventoryPlayer ipl, TileBurette tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        this.fluidSync = new FluidSyncHelper(tile.getFluidInventory(), 0);
        this.func_75146_a((Slot)new SlotNormal((IItemHandler)tile.getInternalInventory(), 0, 52, 53));
        this.bindPlayerInventory(ipl, 0, 84);
    }

    public TileBurette getTile() {
        return this.tile;
    }

    public boolean canTranferFluid(boolean into) {
        IAEFluidTank tileTank = this.tile.getFluidInventory();
        IFluidTankProperties tileTankInfo = tileTank.getTankProperties()[0];
        IAEFluidStack tileFluid = tileTank.getFluidInSlot(0);
        if (into ? tileFluid != null && tileFluid.getStackSize() >= (long)tileTankInfo.getCapacity() : tileFluid == null) {
            return false;
        }
        ItemStack stack = this.tile.getInternalInventory().getStackInSlot(0);
        if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)Objects.requireNonNull(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
        for (IFluidTankProperties itemTankInfo : itemTank.getTankProperties()) {
            if (!(into ? itemTankInfo.canDrain() && tileTankInfo.canFillFluidType(itemTankInfo.getContents()) : itemTankInfo.canFillFluidType(tileFluid.getFluidStack()))) continue;
            return true;
        }
        return false;
    }

    public void tryTransferFluid(int amount, boolean into) {
        ItemStack stack = this.tile.getInternalInventory().getStackInSlot(0);
        if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return;
        }
        IAEFluidTank tileTank = this.tile.getFluidInventory();
        IFluidHandlerItem itemTank = (IFluidHandlerItem)Objects.requireNonNull(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
        if (into) {
            this.transferFluidBetween((IFluidHandler)itemTank, (IFluidHandler)tileTank, amount);
        } else {
            this.transferFluidBetween((IFluidHandler)tileTank, (IFluidHandler)itemTank, amount);
        }
        this.tile.getInternalInventory().setStackInSlot(0, itemTank.getContainer());
    }

    private void transferFluidBetween(IFluidHandler from, IFluidHandler to, int amount) {
        FluidStack fluid = from.drain(amount, false);
        if (fluid == null) {
            return;
        }
        if ((fluid = from.drain(amount = Math.min(amount, to.fill(fluid, false)), true)) != null) {
            fluid.amount -= to.fill(fluid, true);
            if (fluid.amount > 0) {
                from.fill(fluid, true);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.fluidSync.sendDiff((Iterable)this.field_75149_d);
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.fluidSync.sendFull(Collections.singleton(listener));
    }

    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        this.fluidSync.readPacket(fluids);
    }

    @Override
    public boolean canDumpTank(int index) {
        return this.tile.getFluidInventory().getFluidInSlot(0) != null;
    }

    @Override
    public void dumpTank(int index) {
        this.tile.getFluidInventory().setFluidInSlot(0, null);
    }
}

