/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.button;

import appeng.client.gui.widgets.ITooltip;
import com.glodblock.github.FluidCraft;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiFCImgButton
extends GuiButton
implements ITooltip {
    private static final Pattern COMPILE = Pattern.compile("%s");
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private static Map<EnumPair, ButtonAppearance> appearances;
    private final String buttonSetting;
    private boolean halfSize = false;
    private String fillVar;
    private String currentValue;
    private static final String prefix = "ae2fc.tooltip.";
    private static final int SPRITE_SHEET_GRID_SIZE = 4;
    private static final int MAX_INDEX = 15;

    public GuiFCImgButton(int x, int y, String idx, String val) {
        super(0, 0, 16, "");
        this.buttonSetting = idx;
        this.currentValue = val;
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = 16;
        this.field_146121_g = 16;
        if (appearances == null) {
            appearances = new HashMap<EnumPair, ButtonAppearance>();
            this.registerApp(0, "NOT_COMBINE", "DONT_COMBINE", "not_combine");
            this.registerApp(1, "FORCE_COMBINE", "DO_COMBINE", "combine");
            this.registerApp(2, "SEND_MODE", "REAL_FLUID", "real_fluid");
            this.registerApp(3, "SEND_MODE", "FLUID_PACKET", "fake_packet");
            this.registerApp(4, "FLUID_FIRST", "FLUID", "fluid_first");
            this.registerApp(5, "ORIGIN_ORDER", "ITEM", "origin_order");
            this.registerApp(6, "CRAFT_FLUID", "ENCODE", "craft_fluid");
            this.registerApp(7, "SPLITTING", "ALLOW", "allow_splitting");
            this.registerApp(8, "SPLITTING", "PREVENT", "prevent_splitting");
            this.registerApp(9, "BLOCK", "ALL", "block_all");
            this.registerApp(10, "BLOCK", "ITEM", "block_item");
            this.registerApp(11, "BLOCK", "FLUID", "block_fluid");
        }
    }

    private void registerApp(int iconIndex, String setting, String val, String title) {
        ButtonAppearance a = new ButtonAppearance();
        a.displayName = I18n.func_135052_a((String)(prefix + title), (Object[])new Object[0]);
        a.displayValue = I18n.func_135052_a((String)(prefix + title + ".hint"), (Object[])new Object[0]);
        a.index = iconIndex;
        appearances.put(new EnumPair(setting, val), a);
    }

    public void setVisibility(boolean vis) {
        this.field_146125_m = vis;
        this.field_146124_l = vis;
    }

    private int getIconIndex() {
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance app = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (app == null) {
                return 15;
            }
            return app.index;
        }
        return 15;
    }

    public String getSetting() {
        return this.buttonSetting;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void set(String e) {
        if (!this.currentValue.equals(e)) {
            this.currentValue = e;
        }
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public String getFillVar() {
        return this.fillVar;
    }

    public void setFillVar(String fillVar) {
        this.fillVar = fillVar;
    }

    public int xPos() {
        return this.field_146128_h;
    }

    public int yPos() {
        return this.field_146129_i;
    }

    public int getWidth() {
        return this.halfSize ? 8 : 16;
    }

    public int getHeight() {
        return this.halfSize ? 8 : 16;
    }

    public boolean isVisible() {
        return this.field_146125_m;
    }

    public String getMessage() {
        String displayName = null;
        String displayValue = null;
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance buttonAppearance = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (buttonAppearance == null) {
                return "No Such Message";
            }
            displayName = buttonAppearance.displayName;
            displayValue = buttonAppearance.displayValue;
        }
        if (displayName != null) {
            StringBuilder sb;
            int i;
            String name = I18n.func_135052_a(displayName, (Object[])new Object[0]);
            String value = I18n.func_135052_a(displayValue, (Object[])new Object[0]);
            if (name.isEmpty()) {
                name = displayName;
            }
            if (value.isEmpty()) {
                value = displayValue;
            }
            if (this.fillVar != null) {
                value = COMPILE.matcher(value).replaceFirst(this.fillVar);
            }
            if ((i = (sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"))).lastIndexOf("\n")) <= 0) {
                i = 0;
            }
            while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
                sb.replace(i, i + 1, "\n");
            }
            return name + '\n' + sb;
        }
        return null;
    }

    public void func_191745_a(@Nonnull Minecraft par1Minecraft, int par2, int par3, float partialTicks) {
        if (this.field_146125_m) {
            int iconIndex = this.getIconIndex();
            int relativeX = this.field_146128_h;
            int relativeY = this.field_146129_i;
            if (this.halfSize) {
                this.field_146120_f = 8;
                this.field_146121_g = 8;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                relativeX = 0;
                relativeY = 0;
            }
            if (this.field_146124_l) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            par1Minecraft.field_71446_o.func_110577_a(FluidCraft.resource("textures/gui/states.png"));
            this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
            int baseButtonUV = 48;
            int textureSize = 64;
            int overlayU = 16 * (iconIndex % 4);
            int overlayV = 16 * (iconIndex / 4);
            Gui.func_146110_a((int)relativeX, (int)relativeY, (float)48.0f, (float)48.0f, (int)16, (int)16, (float)64.0f, (float)64.0f);
            Gui.func_146110_a((int)relativeX, (int)relativeY, (float)overlayU, (float)overlayV, (int)16, (int)16, (float)64.0f, (float)64.0f);
            this.func_146119_b(par1Minecraft, par2, par3);
            if (this.halfSize) {
                GL11.glPopMatrix();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static class ButtonAppearance {
        public int index;
        public String displayName;
        public String displayValue;

        private ButtonAppearance() {
        }
    }

    private static final class EnumPair {
        final String setting;
        final String value;

        EnumPair(String a, String b) {
            this.setting = a;
            this.value = b;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting.equals(this.setting) && other.value.equals(this.value);
        }
    }
}

