/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.render.StackSizeRenderer;
import appeng.core.localization.GuiText;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.container.ContainerFluidPatternEncoder;
import com.glodblock.github.client.render.FluidRenderUtils;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.GasRenderUtil;
import com.glodblock.github.interfaces.SlotFluid;
import com.glodblock.github.inventory.slot.SlotSingleItem;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.network.CPacketEncodePattern;
import com.glodblock.github.util.Ae2ReflectClient;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.MouseRegionManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFluidPatternEncoder
extends AEBaseGui {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/fluid_pattern_encoder.png");
    private final ContainerFluidPatternEncoder cont;
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);
    private final StackSizeRenderer stackSizeRenderer = Ae2ReflectClient.getStackSizeRenderer(this);

    public GuiFluidPatternEncoder(InventoryPlayer ipl, TileFluidPatternEncoder tile) {
        super((Container)new ContainerFluidPatternEncoder(ipl, tile));
        this.cont = (ContainerFluidPatternEncoder)this.field_147002_h;
        this.mouseRegions.addRegion(141, 38, 10, 10, new MouseRegionManager.Handler(){

            @Override
            public List<String> getTooltip() {
                return Collections.singletonList(I18n.func_135052_a((String)"ae2fc.tooltip.encode_pattern", (Object[])new Object[0]));
            }

            @Override
            public boolean onClick(int button) {
                if (button == 0) {
                    if (GuiFluidPatternEncoder.this.cont.canEncodePattern()) {
                        FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketEncodePattern());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        if (this.mouseRegions.onClick(xCoord, yCoord, btn)) {
            super.func_73864_a(xCoord, yCoord, btn);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)"ae2fc.gui.fluid_pattern_encoder", (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 94, 0x404040);
        this.mouseRegions.render(mouseX, mouseY);
    }

    public void func_146977_a(Slot slot) {
        if (slot instanceof SlotFluid) {
            IAEItemStack stack = ((SlotFluid)slot).getAeStack();
            if (FluidRenderUtils.renderFluidPacketIntoGuiSlot(slot, stack, this.stackSizeRenderer, this.field_146289_q)) {
                return;
            }
            if (ModAndClassUtil.GAS && GasRenderUtil.renderGasPacketIntoGuiSlot(slot, stack, this.stackSizeRenderer, this.field_146289_q)) {
                return;
            }
            super.func_146977_a((Slot)new SlotSingleItem(slot));
            this.stackSizeRenderer.renderStackSize(this.field_146289_q, stack, slot.field_75223_e, slot.field_75221_f);
        } else {
            super.func_146977_a(slot);
        }
    }

    @Nonnull
    public List<String> func_191927_a(ItemStack stack) {
        GasStack gas;
        FluidStack fluid;
        if (stack.func_77973_b() == FCItems.FLUID_PACKET && (fluid = (FluidStack)FakeItemRegister.getStack(stack)) != null) {
            return Arrays.asList(fluid.getLocalizedName(), String.format(TextFormatting.GRAY + "%,d mB", fluid.amount));
        }
        if (ModAndClassUtil.GAS && stack.func_77973_b() == FCGasItems.GAS_PACKET && (gas = (GasStack)FakeItemRegister.getStack(stack)) != null && gas.getGas() != null) {
            return Arrays.asList(gas.getGas().getLocalizedName(), String.format(TextFormatting.GRAY + "%,d mB", gas.amount));
        }
        return super.func_191927_a(stack);
    }
}

