/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiNumberBox;
import appeng.core.localization.GuiText;
import appeng.fluids.util.IAEFluidTank;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.container.ContainerBurette;
import com.glodblock.github.client.render.FluidRenderUtils;
import com.glodblock.github.common.tile.TileBurette;
import com.glodblock.github.handler.ButtonMouseHandler;
import com.glodblock.github.handler.TankMouseHandler;
import com.glodblock.github.network.CPacketTransposeFluid;
import com.glodblock.github.util.MouseRegionManager;
import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiBurette
extends AEBaseGui {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/burette.png");
    private static final int TANK_X = 52;
    private static final int TANK_Y = 17;
    private static final int TANK_WIDTH = 16;
    private static final int TANK_HEIGHT = 32;
    private final ContainerBurette cont;
    private GuiNumberBox amountField;
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);

    public GuiBurette(InventoryPlayer ipl, TileBurette tile) {
        super((Container)new ContainerBurette(ipl, tile));
        this.cont = (ContainerBurette)this.field_147002_h;
        this.mouseRegions.addRegion(52, 17, 16, 32, new TankMouseHandler(this.cont.getTile().getFluidInventory(), 0));
        this.mouseRegions.addRegion(70, 16, 7, 7, ButtonMouseHandler.dumpTank(this.cont, 0));
        this.mouseRegions.addRegion(73, 42, 8, 16, this.createTransposeButton(true));
        this.mouseRegions.addRegion(81, 42, 8, 16, this.createTransposeButton(false));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.amountField = new GuiNumberBox(this.field_146289_q, this.field_147003_i + 95, this.field_147009_r + 46, 28, this.field_146289_q.field_78288_b, Integer.class);
        this.amountField.func_146185_a(false);
        this.amountField.func_146203_f(4);
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_146189_e(true);
        this.amountField.func_146195_b(true);
        this.amountField.func_146180_a("1000");
    }

    private ButtonMouseHandler createTransposeButton(boolean into) {
        return new ButtonMouseHandler(into ? "ae2fc.tooltip.transpose_in" : "ae2fc.tooltip.transpose_out", () -> {
            try {
                int amount = Integer.parseInt(this.amountField.func_146179_b());
                if (this.cont.canTranferFluid(into)) {
                    FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketTransposeFluid(amount, into));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        if (this.mouseRegions.onClick(xCoord, yCoord, btn)) {
            this.amountField.func_146192_a(xCoord, yCoord, btn);
            super.func_73864_a(xCoord, yCoord, btn);
        }
    }

    protected void func_73869_a(char character, int key) throws IOException {
        block6: {
            if (!this.func_146983_a(key)) {
                if ((key == 211 || key == 205 || key == 203 || key == 14 || Character.isDigit(character)) && this.amountField.func_146201_a(character, key)) {
                    try {
                        int amount = Integer.parseInt(this.amountField.func_146179_b());
                        if (amount < 0) {
                            this.amountField.func_146180_a("1");
                            break block6;
                        }
                        this.amountField.func_146180_a(Long.toString(amount));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    super.func_73869_a(character, key);
                }
            }
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
        this.amountField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)"ae2fc.gui.burette", (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 94, 0x404040);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IAEFluidTank fluidInv = this.cont.getTile().getFluidInventory();
        FluidRenderUtils.renderFluidIntoGuiCleanly(52, 17, 16, 32, fluidInv.getFluidInSlot(0), fluidInv.getTankProperties()[0].getCapacity());
        this.mouseRegions.render(mouseX, mouseY);
    }
}

