/*
 * Decompiled with CFR 0.152.
 */
package com.github.upcraftlp.inhaler.capability;

import com.github.upcraftlp.inhaler.GaspunkInhaler;
import com.github.upcraftlp.inhaler.InhalerConfig;
import com.github.upcraftlp.inhaler.api.IEntityGasEffect;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.api.IGas;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class CapabilityGasEffect
implements ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=IEntityGasEffect.class)
    public static final Capability<IEntityGasEffect> GAS_EFFECT_CAPABILITY = null;
    private final IEntityGasEffect instance = (IEntityGasEffect)GAS_EFFECT_CAPABILITY.getDefaultInstance();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == GAS_EFFECT_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GAS_EFFECT_CAPABILITY ? GAS_EFFECT_CAPABILITY.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return GAS_EFFECT_CAPABILITY.getStorage().writeNBT(GAS_EFFECT_CAPABILITY, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        GAS_EFFECT_CAPABILITY.getStorage().readNBT(GAS_EFFECT_CAPABILITY, (Object)this.instance, null, nbt);
    }

    public static class Provider
    implements IEntityGasEffect {
        private final Map<IGas, Float> gases = Maps.newHashMap();

        @Override
        public Map<IGas, Float> getGases() {
            return ImmutableMap.copyOf(this.gases);
        }

        @Override
        public float getMinConcentration() {
            return 0.02f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyEffects(EntityLivingBase entity, IBreathingHandler handler) {
            Map<IGas, Float> map = this.gases;
            synchronized (map) {
                Iterator<IGas> iterator = this.gases.keySet().iterator();
                while (iterator.hasNext()) {
                    float concentration;
                    IGas gas;
                    gas.applyEffect(entity, handler, concentration, (concentration = this.gases.get(gas = iterator.next()).floatValue()) == 1.0f, true);
                    this.gases.put(gas, Float.valueOf(concentration *= (float)Math.pow(2.0, 1.0 / InhalerConfig.halfLife)));
                    if (GaspunkInhaler.isDebugMode()) {
                        GaspunkInhaler.getLogger().info("gas effect: {} (remaining concentration: {})", (Object)gas.getRegistryName(), (Object)Float.valueOf(concentration));
                    }
                    if (!(concentration < this.getMinConcentration())) continue;
                    gas.onExitCloud(entity, handler);
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addGasEffect(IGas gas) {
            Map<IGas, Float> map = this.gases;
            synchronized (map) {
                this.gases.put(gas, Float.valueOf(1.0f));
            }
        }

        @Override
        public void addGasEffect(IGas gas, float concentration) {
            this.gases.put(gas, Float.valueOf(concentration));
        }
    }

    public static class Storage
    implements Capability.IStorage<IEntityGasEffect> {
        @Nullable
        public NBTBase writeNBT(Capability<IEntityGasEffect> capability, IEntityGasEffect instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<IGas, Float> entry : instance.getGases().entrySet()) {
                nbt.func_74776_a(entry.getKey().getRegistryName().toString(), entry.getValue().floatValue());
            }
            return nbt;
        }

        public void readNBT(Capability<IEntityGasEffect> capability, IEntityGasEffect instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                IForgeRegistry gasRegistry = GameRegistry.findRegistry(IGas.class);
                NBTTagCompound compound = (NBTTagCompound)nbt;
                for (String name : compound.func_150296_c()) {
                    if (!compound.func_150297_b(name, 5)) continue;
                    IGas gas = (IGas)gasRegistry.getValue(new ResourceLocation(name));
                    instance.addGasEffect(gas, compound.func_74760_g(name));
                }
            }
        }
    }
}

