/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.lib.util.DimPos;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MovedBlock {
    public static final MovedBlock AIR = new MovedBlock(Blocks.field_150350_a.func_176223_P(), null);
    public final NBTTagCompound nbt;
    public final IBlockState block;

    public MovedBlock(IBlockState block, NBTTagCompound tile) {
        this.block = block;
        this.nbt = tile;
    }

    public static MovedBlock cut(DimPos pos, @Nullable Map<DimPos, NBTTagCompound> addedTileEntities) {
        NBTTagCompound nbt;
        WorldServer world = pos.getWorldServer();
        Chunk chunk = world.func_175726_f((BlockPos)pos);
        TileEntity te = (TileEntity)chunk.func_177434_r().remove((Object)pos);
        if (te == null) {
            nbt = addedTileEntities != null ? addedTileEntities.remove((Object)pos) : null;
        } else {
            te.onChunkUnload();
            world.field_147482_g.remove(te);
            world.field_175730_i.remove(te);
            nbt = te.serializeNBT();
        }
        return new MovedBlock(chunk.func_177435_g((BlockPos)pos), nbt);
    }

    public boolean paste(DimPos pos, @Nullable Map<DimPos, NBTTagCompound> addedTileEntities) {
        int z;
        int i;
        World world = pos.getWorld();
        if (world == null || !world.func_175701_a((BlockPos)pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f((BlockPos)pos);
        IBlockState newState = this.block;
        Block newBlock = newState.func_177230_c();
        IBlockState oldState = chunk.func_177435_g((BlockPos)pos);
        Block oldBlock = oldState.func_177230_c();
        int oldLight = oldState.getLightValue((IBlockAccess)world, (BlockPos)pos);
        int oldOpacity = oldState.getLightOpacity((IBlockAccess)world, (BlockPos)pos);
        int x = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        if (y >= chunk.field_76638_b[i = (z = pos.func_177952_p() & 0xF) << 4 | x] - 1) {
            chunk.field_76638_b[i] = -999;
        }
        if (oldState == newState) {
            if (oldBlock.hasTileEntity(oldState)) {
                world.func_175713_t((BlockPos)pos);
            }
        } else {
            ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
            ExtendedBlockStorage ebs = storageArrays[y >> 4];
            int h = chunk.func_177445_q()[i];
            boolean topPlaced = false;
            if (ebs == Chunk.field_186036_a) {
                if (newBlock == Blocks.field_150350_a) {
                    return true;
                }
                storageArrays[y >> 4] = ebs = new ExtendedBlockStorage(y >> 4 << 4, world.field_73011_w.func_191066_m());
                topPlaced = y >= h;
            }
            ebs.func_177484_a(x, y & 0xF, z, newState);
            if (oldBlock.hasTileEntity(oldState)) {
                world.func_175713_t((BlockPos)pos);
            }
            if (ebs.func_177485_a(x, y & 0xF, z).func_177230_c() != newBlock) {
                return false;
            }
            if (topPlaced) {
                chunk.func_76603_b();
            } else {
                int opacity = newState.getLightOpacity((IBlockAccess)world, (BlockPos)pos);
                if (opacity > 0) {
                    if (y >= h) {
                        chunk.func_76615_h(x, y + 1, z);
                    }
                } else if (y == h - 1) {
                    chunk.func_76615_h(x, y, z);
                }
                if (opacity != oldOpacity && (opacity < oldOpacity || chunk.func_177413_a(EnumSkyBlock.SKY, (BlockPos)pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)pos) > 0)) {
                    chunk.func_76595_e(x, z);
                }
            }
        }
        if (this.nbt != null) {
            if (addedTileEntities != null) {
                addedTileEntities.put(pos, this.nbt);
            } else {
                this.nbt.func_74768_a("x", pos.func_177958_n());
                this.nbt.func_74768_a("y", pos.func_177956_o());
                this.nbt.func_74768_a("z", pos.func_177952_p());
                chunk.func_150813_a(TileEntity.func_190200_a((World)world, (NBTTagCompound)this.nbt));
            }
        }
        chunk.func_177427_f(true);
        if (newState.getLightOpacity((IBlockAccess)world, (BlockPos)pos) != oldOpacity || newState.getLightValue((IBlockAccess)world, (BlockPos)pos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x((BlockPos)pos);
            world.field_72984_F.func_76319_b();
        }
        world.markAndNotifyBlock((BlockPos)pos, chunk, oldState, newState, addedTileEntities == null ? 3 : 2);
        return true;
    }

    public static void addTileEntities(Map<DimPos, NBTTagCompound> addedTileEntities) {
        for (Map.Entry<DimPos, NBTTagCompound> e : addedTileEntities.entrySet()) {
            DimPos pos = e.getKey();
            NBTTagCompound nbt = e.getValue();
            nbt.func_74768_a("x", pos.func_177958_n());
            nbt.func_74768_a("y", pos.func_177956_o());
            nbt.func_74768_a("z", pos.func_177952_p());
            World world = pos.getWorld();
            TileEntity te = TileEntity.func_190200_a((World)world, (NBTTagCompound)nbt);
            if (te == null) continue;
            world.func_175726_f((BlockPos)pos).func_150813_a(te);
        }
    }

    @Deprecated
    public static boolean setBlock(World world, BlockPos pos, IBlockState state, TileEntity tile) {
        int bz;
        int p;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IBlockState state0 = chunk.func_177435_g(pos);
        Block block = state.func_177230_c();
        int oldLight = state0.getLightValue((IBlockAccess)world, pos);
        int oldOpac = state0.getLightOpacity((IBlockAccess)world, pos);
        world.func_175713_t(pos);
        if (state0 == state) {
            world.func_175690_a(pos, tile);
            world.func_184138_a(pos, state0, state, 3);
            return true;
        }
        int bx = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        if (y >= chunk.field_76638_b[p = (bz = pos.func_177952_p() & 0xF) << 4 | bx] - 1) {
            chunk.field_76638_b[p] = -999;
        }
        int h = chunk.func_177445_q()[p];
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, world.field_73011_w.func_191066_m());
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = y >= h;
        }
        extendedblockstorage.func_177484_a(bx, y & 0xF, bz, state);
        if (extendedblockstorage.func_177485_a(bx, y & 0xF, bz).func_177230_c() != block) {
            return false;
        }
        if (flag) {
            chunk.func_76603_b();
        } else {
            int opac = state.getLightOpacity((IBlockAccess)world, pos);
            if (opac > 0) {
                if (y >= h) {
                    chunk.func_76615_h(bx, y + 1, bz);
                }
            } else if (y == h - 1) {
                chunk.func_76615_h(bx, y, bz);
            }
            if (opac != oldOpac && (opac < oldOpac || chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                chunk.func_76595_e(bx, bz);
            }
        }
        world.func_175690_a(pos, tile);
        chunk.func_177427_f(true);
        if (state.getLightOpacity((IBlockAccess)world, pos) != oldOpac || state.getLightValue((IBlockAccess)world, pos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(pos);
            world.field_72984_F.func_76319_b();
        }
        world.func_184138_a(pos, state0, state, 3);
        return true;
    }

    public static void moveEntity(Entity entity, int dim, double x, double y, double z) {
        if (entity.field_70128_L || entity.func_184218_aH()) {
            return;
        }
        if (dim == entity.field_71093_bK) {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_70634_a(x, y, z);
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
            return;
        }
        List passengers = entity.func_184188_bt();
        for (Entity e : passengers) {
            e.func_184210_p();
            MovedBlock.moveEntity(e, dim, x, y, z);
        }
        entity = entity instanceof EntityPlayerMP ? MovedBlock.transferPlayer((EntityPlayerMP)entity, dim, x, y, z) : MovedBlock.transferEntity(entity, dim, x, y, z);
        for (Entity e : passengers) {
            e.func_184205_a(entity, true);
        }
    }

    public static EntityPlayerMP transferPlayer(EntityPlayerMP player, int dimN, double x, double y, double z) {
        WorldServer worldO = (WorldServer)player.field_70170_p;
        MinecraftServer server = worldO.func_73046_m();
        WorldServer worldN = server.func_71218_a(dimN);
        PlayerList pl = server.func_184103_al();
        int dimO = player.field_71093_bK;
        player.field_71093_bK = dimN;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, worldN.func_175659_aa(), worldN.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        pl.func_187243_f(player);
        worldO.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        worldN.func_72838_d((Entity)player);
        worldN.func_72866_a((Entity)player, false);
        player.func_70029_a((World)worldN);
        pl.func_72375_a(player, worldO);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldN);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        pl.func_72354_b(player, worldN);
        pl.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimO, dimN);
        return player;
    }

    public static Entity transferEntity(Entity entityO, int dimN, double x, double y, double z) {
        if (!ForgeHooks.onTravelToDimension((Entity)entityO, (int)dimN)) {
            return null;
        }
        entityO.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        entityO.field_71093_bK = dimN;
        entityO.field_70170_p.func_72900_e(entityO);
        entityO.field_70128_L = false;
        entityO.field_70170_p.field_72984_F.func_76320_a("reposition");
        WorldServer worldO = (WorldServer)entityO.field_70170_p;
        entityO.func_70012_b(x, y, z, entityO.field_70177_z, entityO.field_70125_A);
        worldO.func_72866_a(entityO, false);
        entityO.field_70170_p.field_72984_F.func_76318_c("reloading");
        MinecraftServer server = worldO.func_73046_m();
        WorldServer worldN = server.func_71218_a(dimN);
        Entity entityN = EntityList.func_191304_a(entityO.getClass(), (World)worldN);
        if (entityN != null) {
            NBTTagCompound nbttagcompound = entityO.func_189511_e(new NBTTagCompound());
            nbttagcompound.func_82580_o("Dimension");
            entityN.func_70020_e(nbttagcompound);
            boolean flag = entityN.field_98038_p;
            entityN.field_98038_p = true;
            worldN.func_72838_d(entityN);
            entityN.field_98038_p = flag;
            worldN.func_72866_a(entityN, false);
        }
        entityO.field_70128_L = true;
        entityO.field_70170_p.field_72984_F.func_76319_b();
        worldO.func_82742_i();
        worldN.func_82742_i();
        entityO.field_70170_p.field_72984_F.func_76319_b();
        return entityN;
    }
}

