/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import com.google.common.base.MoreObjects;
import java.lang.ref.WeakReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class DimPos
extends BlockPos {
    private static final WeakReference<World> NO_WORLD = new WeakReference<Object>(null);
    public final int dimId;
    private WeakReference<World> world = NO_WORLD;
    private Side side;

    public DimPos(Entity source) {
        super(source);
        this.dimId = source.field_71093_bK;
        World world = source.field_70170_p;
        if (world != null) {
            this.world = new WeakReference<World>(world);
            this.side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        }
    }

    public DimPos(TileEntity source) {
        this((Vec3i)source.func_174877_v(), source.func_145831_w());
    }

    public DimPos(Vec3i source, World world) {
        this(source, world.field_73011_w.getDimension());
        this.world = new WeakReference<World>(world);
        this.side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
    }

    public DimPos(Vec3i source, int dim) {
        this(source.func_177958_n(), source.func_177956_o(), source.func_177952_p(), dim);
    }

    public DimPos(int x, int y, int z, int d) {
        super(x, y, z);
        this.dimId = d;
    }

    public DimPos(int x, int y, int z, WorldServer world) {
        this(x, y, z, world.field_73011_w.getDimension());
        this.world = new WeakReference<WorldServer>(world);
        this.side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
    }

    public DimPos assignWorld(World world) {
        if (world.field_73011_w.getDimension() != this.dimId) {
            throw new IllegalArgumentException("given world represents a different dimension");
        }
        if (this.side != null && this.side == Side.CLIENT ^ world.field_72995_K) {
            throw new IllegalArgumentException("given world represents a different logical side");
        }
        this.world = new WeakReference<World>(world);
        this.side = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        return this;
    }

    public World getWorld() {
        return (World)this.world.get();
    }

    public WorldServer getWorldServer() {
        World world = (World)this.world.get();
        if (world instanceof WorldServer) {
            return (WorldServer)world;
        }
        WorldServer ws = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimId);
        if (this.side != Side.CLIENT) {
            this.world = new WeakReference<WorldServer>(ws);
            this.side = Side.SERVER;
        }
        return ws;
    }

    public Side getSide() {
        return this.side;
    }

    public DimPos add(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this;
        }
        DimPos pos = new DimPos(this.func_177958_n() + x, this.func_177956_o() + y, this.func_177952_p() + z, this.dimId);
        pos.world = this.world;
        pos.side = this.side;
        return pos;
    }

    public DimPos offset(EnumFacing facing, int n) {
        if (n == 0) {
            return this;
        }
        DimPos pos = new DimPos(this.func_177958_n() + facing.func_82601_c() * n, this.func_177956_o() + facing.func_96559_d() * n, this.func_177952_p() + facing.func_82599_e() * n, this.dimId);
        pos.world = this.world;
        pos.side = this.side;
        return pos;
    }

    public boolean equals(Object o) {
        return super.equals(o) && (!(o instanceof DimPos) || ((DimPos)((Object)o)).dimId == this.dimId);
    }

    public int compareTo(Vec3i o) {
        int dim;
        if (o instanceof DimPos && (dim = ((DimPos)o).dimId) != this.dimId) {
            return this.dimId - dim;
        }
        return super.compareTo(o);
    }

    public double func_177951_i(Vec3i to) {
        return to instanceof DimPos && ((DimPos)to).dimId != this.dimId ? Double.POSITIVE_INFINITY : super.func_177951_i(to);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("x", this.func_177958_n()).add("y", this.func_177956_o()).add("z", this.func_177952_p()).add("d", this.dimId).toString();
    }

    public boolean isLoaded() {
        World world = (World)this.world.get();
        return world != null && world.func_175667_e((BlockPos)this);
    }

    public IBlockState getBlock() {
        World world = (World)this.world.get();
        return world == null ? Blocks.field_150350_a.func_176223_P() : world.func_180495_p((BlockPos)this);
    }

    public boolean setBlock(IBlockState state) {
        World world = (World)this.world.get();
        return world != null && world.func_175656_a((BlockPos)this, state);
    }

    public TileEntity getTileEntity() {
        World world = (World)this.world.get();
        return world == null || !world.func_175667_e((BlockPos)this) ? null : world.func_175625_s((BlockPos)this);
    }
}

