/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity.test;

import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Slider;
import cd4017be.lib.Gui.comp.TankInterface;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.IntBiConsumer;
import cd4017be.lib.util.ItemFluidUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidSupply
extends BaseTileEntity
implements IFluidHandler,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler,
ITankContainer {
    public static int MAX_SLOTS = 12;
    ArrayList<Slot> slots = new ArrayList();
    int scroll;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addFix(1).addMulFix(4, 24).addVar(12);
    @SideOnly(value=Side.CLIENT)
    private static final ResourceLocation TEX = new ResourceLocation("cd4017be_lib", "textures/gui/supply.png");

    public IFluidTankProperties[] getTankProperties() {
        int l = this.slots.size();
        IFluidTankProperties[] props = this.slots.toArray(new IFluidTankProperties[Math.min(l + 1, MAX_SLOTS)]);
        if (props.length > l) {
            props[l] = new FluidTankProperties(null, Integer.MAX_VALUE);
        }
        return props;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int n = resource.amount;
        for (Slot s : this.slots) {
            if (!resource.isFluidEqual(s.stack)) continue;
            if (doFill) {
                s.countIn += n;
            }
            return n;
        }
        if (this.slots.size() >= MAX_SLOTS) {
            return 0;
        }
        if (doFill) {
            Slot s = new Slot(new FluidStack(resource, 1000));
            s.countIn = n;
            this.slots.add(s);
        }
        return n;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int n = resource.amount;
        for (Slot s : this.slots) {
            if (!resource.isFluidEqual(s.stack)) continue;
            n = Math.min(n, s.stack.amount);
            if (doDrain) {
                s.countOut += n;
            }
            return new FluidStack(s.stack, n);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.slots.isEmpty()) {
            return null;
        }
        Slot s = this.slots.get(0);
        int n = Math.min(maxDrain, s.stack.amount);
        if (doDrain) {
            s.countOut += n;
        }
        return new FluidStack(s.stack, n);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        NBTTagList list = new NBTTagList();
        for (Slot s : this.slots) {
            NBTTagCompound tag = s.stack.writeToNBT(new NBTTagCompound());
            tag.func_74768_a("in", s.countIn);
            tag.func_74768_a("out", s.countOut);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("slots", (NBTBase)list);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        this.slots.clear();
        for (NBTBase tb : nbt.func_150295_c("slots", 10)) {
            NBTTagCompound tag = (NBTTagCompound)tb;
            Slot s = new Slot(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
            s.countIn = tag.func_74762_e("in");
            s.countOut = tag.func_74762_e("out");
            this.slots.add(s);
        }
    }

    @Override
    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        AdvancedContainer cont = new AdvancedContainer(this, ssb.build(this.field_145850_b.field_72995_K), player);
        cont.addPlayerInventory(8, 104);
        if (this.field_145850_b.field_72995_K) {
            while (this.slots.size() < 12) {
                this.slots.add(new Slot(null));
            }
        }
        return cont;
    }

    @Override
    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        int i;
        state.buffer.writeByte(this.scroll);
        int l = this.scroll + 12;
        for (i = this.scroll; i < l; ++i) {
            if (i < this.slots.size()) {
                Slot s = this.slots.get(i);
                state.buffer.writeInt(s.countIn).writeInt(s.countOut);
                continue;
            }
            state.buffer.writeLong(0L);
        }
        state.endFixed();
        for (i = 0; i < 12; ++i) {
            state.set(25 + i, i < this.slots.size() ? this.slots.get((int)i).stack : null);
        }
    }

    @Override
    public void readState(StateSyncClient state, AdvancedContainer cont) throws IOException {
        Slot s;
        int i;
        this.scroll = state.get(this.scroll);
        for (i = 0; i < 12; ++i) {
            s = this.slots.get(i);
            s.countIn = state.get(s.countIn);
            s.countOut = state.get(s.countOut);
        }
        for (i = 0; i < 12; ++i) {
            s = this.slots.get(i);
            s.stack = state.get(s.stack);
        }
    }

    @Override
    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @Override
    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        int cmd = pkt.readByte();
        if (cmd < 0) {
            this.scroll = pkt.readUnsignedByte();
            return;
        }
        if (cmd >= 32) {
            if ((cmd = (cmd & 0xF) + this.scroll) < this.slots.size()) {
                this.slots.get((int)cmd).stack = ItemFluidUtil.readFluidStack(pkt);
            } else {
                if (cmd >= MAX_SLOTS) {
                    return;
                }
                this.slots.add(new Slot(ItemFluidUtil.readFluidStack(pkt)));
            }
            return;
        }
        boolean zero = cmd < 16;
        if ((cmd = (cmd & 0xF) + this.scroll) >= this.slots.size()) {
            return;
        }
        Slot s = this.slots.get(cmd);
        if (zero) {
            s.countIn = 0;
            s.countOut = 0;
        } else if (s.countIn < s.countOut) {
            s.countOut -= s.countIn;
            s.countIn = 0;
        } else {
            s.countIn -= s.countOut;
            s.countOut = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getGuiScreen(EntityPlayer player, int id) {
        ModularGui gui = new ModularGui(this.getContainer(player, id));
        GuiFrame frame = new GuiFrame(gui, 186, 186, 25).title("gui.cd4017be.fluid_supp.name", 0.5f).background(TEX, 0, 70);
        new Slider(frame, 8, 12, 70, 170, 16, 176, 0, false, () -> this.scroll, x -> {
            int s = (int)x;
            if (s == this.scroll) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = (byte)-1;
            this.scroll = s;
            objectArray[1] = (byte)this.scroll;
            gui.sendPkt(objectArray);
        }, null, 0.0, MAX_SLOTS - 12).scroll(-3.0f).tooltip("gui.cd4017be.scroll");
        IntBiConsumer setFluid = (i, a) -> {
            FluidStack fluid = this.getTank(i);
            if (fluid != null && a < 0) {
                fluid.amount = fluid.amount + (a + 2) * (GuiScreen.func_146272_n() ? 10 : 1) * (GuiScreen.func_146271_m() ? 100 : 1) * (GuiScreen.func_175283_s() ? 1 : 1000);
                if (fluid.amount < 0) {
                    fluid.amount = 0;
                }
            } else {
                fluid = FluidUtil.getFluidContained((ItemStack)gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
            }
            PacketBuffer buff = GuiNetworkHandler.preparePacket(gui.container);
            buff.writeByte(32 + i);
            ItemFluidUtil.writeFluidStack(buff, fluid);
            GuiNetworkHandler.GNH_INSTANCE.sendToServer(buff);
        };
        for (int j = 0; j < 4; ++j) {
            for (int i2 = 0; i2 < 3; ++i2) {
                byte k = (byte)(j * 3 + i2);
                new TankInterface(frame, 16, 16, 8 + i2 * 54, 16 + j * 18, this, k, setFluid);
                new FormatText(frame, 36, 16, 24 + i2 * 54, 16 + j * 18, "\\\u00a72%d\n\u00a74%d", this.slots.get(k));
                new Button(frame, 36, 16, 24 + i2 * 54, 16 + j * 18, 0, null, a -> gui.sendPkt(a == 0 ? k : (byte)(k | 0x10))).tooltip("gui.cd4017be.reset_count");
            }
        }
        gui.compGroup = frame;
        return gui;
    }

    @Override
    public int getTanks() {
        return MAX_SLOTS;
    }

    @Override
    public FluidStack getTank(int i) {
        return i < this.slots.size() ? this.slots.get((int)i).stack : null;
    }

    @Override
    public int getCapacity(int i) {
        return 0;
    }

    @Override
    public void setTank(int i, FluidStack fluid) {
    }

    public static class Slot
    implements IFluidTankProperties,
    Supplier<Object[]> {
        public FluidStack stack;
        public int countOut;
        public int countIn;

        public Slot(FluidStack stack) {
            this.stack = stack;
        }

        @Override
        public Object[] get() {
            return new Object[]{this.countIn, this.countOut};
        }

        public FluidStack getContents() {
            return this.stack;
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return this.stack.amount > 0;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return fluidStack.isFluidEqual(this.stack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return fluidStack.isFluidEqual(this.stack);
        }
    }
}

