/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity.test;

import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Progressbar;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergySupply
extends BaseTileEntity
implements IEnergyStorage,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler,
BaseTileEntity.ITickableServerOnly {
    public int lastIn;
    public int lastOut;
    public int limitIn;
    public int flowIn;
    public int limitOut;
    public int flowOut;
    public long t0;
    public long sumIn;
    public long sumOut;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addFix(4, 4, 4, 4, 8, 8, 8);
    @SideOnly(value=Side.CLIENT)
    private static final ResourceLocation TEX = new ResourceLocation("cd4017be_lib", "textures/gui/supply.png");

    public void func_73660_a() {
        this.lastIn = this.flowIn;
        this.lastOut = this.flowOut;
        this.flowIn = 0;
        this.flowOut = 0;
        if (this.limitOut > 0) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IEnergyStorage acc = (IEnergyStorage)Utils.neighborCapability(this, side, CapabilityEnergy.ENERGY);
                if (acc == null) continue;
                this.extractEnergy(acc.receiveEnergy(this.limitOut, false), false);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive > this.limitIn) {
            maxReceive = this.limitIn;
        }
        if (!simulate) {
            this.flowIn += maxReceive;
            this.sumIn += (long)maxReceive;
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.limitOut) {
            maxExtract = this.limitOut;
        }
        if (!simulate) {
            this.flowOut += maxExtract;
            this.sumOut += (long)maxExtract;
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        return this.limitOut;
    }

    public int getMaxEnergyStored() {
        int n = this.limitIn + this.limitOut;
        return n < 0 ? Integer.MAX_VALUE : n;
    }

    public boolean canExtract() {
        return this.limitOut > 0;
    }

    public boolean canReceive() {
        return this.limitIn > 0;
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        nbt.func_74768_a("li", this.limitIn);
        nbt.func_74768_a("lo", this.limitOut);
        nbt.func_74772_a("si", this.sumIn);
        nbt.func_74772_a("so", this.sumOut);
        nbt.func_74772_a("t0", this.t0);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        this.limitIn = nbt.func_74762_e("li");
        this.limitOut = nbt.func_74762_e("lo");
        this.sumIn = nbt.func_74763_f("si");
        this.sumOut = nbt.func_74763_f("so");
        this.t0 = nbt.func_74763_f("t0");
    }

    @Override
    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        return new AdvancedContainer(this, ssb.build(this.field_145850_b.field_72995_K), player);
    }

    @Override
    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.putAll(this.lastIn, this.lastOut, this.limitIn, this.limitOut, this.sumIn, this.sumOut, this.field_145850_b.func_82737_E() - this.t0 - 1L);
    }

    @Override
    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.flowIn = state.get(this.flowIn);
        this.flowOut = state.get(this.flowOut);
        this.limitIn = state.get(this.limitIn);
        this.limitOut = state.get(this.limitOut);
        this.sumIn = state.get(this.sumIn);
        this.sumOut = state.get(this.sumOut);
        this.t0 = state.get(this.t0);
    }

    @Override
    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @Override
    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.limitIn = pkt.readInt();
                if (this.limitIn >= 0) break;
                this.limitIn = 0;
                break;
            }
            case 1: {
                this.limitOut = pkt.readInt();
                if (this.limitOut >= 0) break;
                this.limitOut = 0;
                break;
            }
            case 2: {
                this.sumIn = 0L;
                this.sumOut = 0L;
                this.t0 = this.field_145850_b.func_82737_E();
                break;
            }
            default: {
                return;
            }
        }
        this.markDirty(0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getGuiScreen(EntityPlayer player, int id) {
        ModularGui gui = new ModularGui(this.getContainer(player, id));
        GuiFrame frame = new GuiFrame(gui, 169, 67, 10).background(TEX, 0, 0).title("gui.cd4017be.energy_supp.name", 0.5f);
        new TextField(frame, 70, 7, 19, 16, 12, () -> Integer.toString(this.limitOut), t -> {
            try {
                gui.sendPkt((byte)1, Integer.parseInt(t));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).color(-14671840, -8388608).tooltip("gui.cd4017be.limit_o");
        new TextField(frame, 70, 7, 91, 16, 12, () -> Integer.toString(this.limitIn), t -> {
            try {
                gui.sendPkt((byte)0, Integer.parseInt(t));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).color(-14671840, -8388608).tooltip("gui.cd4017be.limit_i");
        new Progressbar(frame, 72, 9, 18, 24, 184, 0, 0, () -> -((double)this.flowOut) / (double)this.limitOut, 0.0, -1.0);
        new Progressbar(frame, 72, 9, 90, 24, 184, 9, 0, () -> (double)this.flowIn / (double)this.limitIn);
        new Progressbar(frame, 72, 9, 18, 42, 184, 0, 0, () -> -((double)this.sumOut) / (double)this.t0 / (double)this.limitOut, 0.0, -1.0);
        new Progressbar(frame, 72, 9, 90, 42, 184, 9, 0, () -> (double)this.sumIn / (double)this.t0 / (double)this.limitIn);
        new FormatText(frame, 70, 7, 19, 25, "\\%d\n%1$.6u RF\n%2$.6u RF/t", () -> new Object[]{this.flowOut, (double)this.sumOut, (double)this.sumOut / (double)this.t0}).align(0.0f).color(-14671840);
        new FormatText(frame, 70, 7, 91, 25, "\\%d\n%1$.6u RF\n%2$.6u RF/t", () -> new Object[]{this.flowIn, (double)this.sumIn, (double)this.sumIn / (double)this.t0}).align(0.0f).color(-14671840);
        new FormatText(frame, 126, 9, 18, 51, "\\%d:%02d:%05.2f", () -> new Object[]{this.t0 / 72000L, this.t0 / 1200L % 60L, (double)(this.t0 % 1200L) / 20.0}).align(0.5f).color(-14671840);
        new Button(frame, 18, 9, 144, 51, 0, null, a -> gui.sendPkt((byte)2)).tooltip("gui.cd4017be.reset_count");
        gui.compGroup = frame;
        return gui;
    }
}

