/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import java.util.Arrays;
import java.util.function.Function;

public class Array
implements IOperand {
    public IOperand[] array;

    public Array(int cap) {
        this.array = new IOperand[cap];
    }

    public Array(IOperand ... arr) {
        this.array = arr;
    }

    public <T> Array(T[] objects, Function<T, IOperand> wrapper) {
        int n = objects.length;
        this.array = new IOperand[n];
        for (int i = 0; i < n; ++i) {
            this.array[i] = wrapper.apply(objects[i]);
        }
    }

    @Override
    public boolean asBool() {
        return this.array.length != 0;
    }

    @Override
    public IOperand addR(IOperand x) {
        if (x instanceof Array) {
            IOperand[] a = ((Array)x).array;
            int l = this.array.length;
            int l1 = a.length;
            IOperand[] arr = Arrays.copyOf(this.array, l + l1);
            System.arraycopy(a, 0, arr, l, l1);
            return new Array(arr);
        }
        int l = this.array.length;
        IOperand[] arr = Arrays.copyOf(this.array, l + 1);
        arr[l] = x;
        return new Array(arr);
    }

    @Override
    public IOperand addL(IOperand x) {
        int l = this.array.length;
        IOperand[] arr = new IOperand[l + 1];
        arr[0] = x;
        System.arraycopy(this.array, 0, arr, 1, l);
        return new Array(arr);
    }

    @Override
    public IOperand subR(IOperand x) {
        IOperand[] a = this.array;
        if (x instanceof Array) {
            IOperand[] b = ((Array)x).array;
            int l = a.length;
            int n = 0;
            int[] idx = new int[l];
            for (int i = 0; i < l; ++i) {
                IOperand y = a[i];
                boolean stay = true;
                for (IOperand z : b) {
                    if (!z.equals(y)) continue;
                    stay = false;
                    break;
                }
                if (!stay) continue;
                idx[n++] = i;
            }
            if (n == l) {
                return this;
            }
            IOperand[] c = new IOperand[n];
            for (int i = 0; i < n; ++i) {
                c[i] = a[idx[i]];
            }
            return new Array(c);
        }
        int l = a.length;
        for (int i = 0; i < l; ++i) {
            if (!x.equals(a[i])) continue;
            IOperand[] b = new IOperand[--l];
            System.arraycopy(a, 0, b, 0, i);
            System.arraycopy(a, i + 1, b, i, l - i);
            return new Array(b);
        }
        return this;
    }

    @Override
    public IOperand grR(IOperand x) {
        IOperand[] a = this.array;
        int l = a.length;
        for (int i = 0; i < l; ++i) {
            if (!x.equals(a[i])) continue;
            return new Number(i + 1);
        }
        return Number.FALSE;
    }

    @Override
    public IOperand grL(IOperand x) {
        try {
            for (IOperand op : this.array) {
                if (x.grR(op).asBool()) continue;
                return Number.FALSE;
            }
            return Number.TRUE;
        }
        catch (Error e) {
            return IOperand.super.grL(x);
        }
    }

    @Override
    public IOperand nlsR(IOperand x) {
        if (x instanceof Array) {
            IOperand[] b;
            IOperand[] a = this.array;
            for (IOperand opB : b = ((Array)x).array) {
                boolean found = false;
                for (IOperand opA : a) {
                    if (!opB.equals(opA)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return Number.FALSE;
            }
            return Number.TRUE;
        }
        try {
            IOperand[] a = this.array;
            int l = a.length;
            for (int i = 0; i < l; ++i) {
                if (!x.nlsR(a[i]).asBool()) continue;
                return new Number(i + 1);
            }
            return Number.FALSE;
        }
        catch (Error e) {
            return x.nlsL(this);
        }
    }

    @Override
    public IOperand nlsL(IOperand x) {
        return this.grL(x);
    }

    @Override
    public IOperand len() {
        return new Number(this.array.length);
    }

    @Override
    public IOperand get(IOperand idx) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.array.length) {
            return this.array[i];
        }
        return Nil.NIL;
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.array.length) {
            this.array[i] = val;
        }
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new Iterator();
    }

    public Object[] value() {
        int l = this.array.length;
        Object[] arr = new Object[l];
        for (int i = l - 1; i >= 0; --i) {
            arr[i] = this.array[i].value();
        }
        return arr;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    class Iterator
    implements IOperand.OperandIterator {
        int idx;

        Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < Array.this.array.length;
        }

        @Override
        public IOperand next() {
            return Array.this.array[this.idx++];
        }

        @Override
        public void set(IOperand e) {
            Array.this.array[this.idx - 1] = e;
        }

        @Override
        public void reset() {
            this.idx = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

