/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.render.IHardCodedModel;
import cd4017be.lib.render.IModeledTESR;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.render.model.ModelContext;
import cd4017be.lib.render.model.ModelVariant;
import cd4017be.lib.render.model.NBTModel;
import cd4017be.lib.render.model.ParamertisedVariant;
import cd4017be.lib.render.model.RawModelData;
import cd4017be.lib.render.model.TextureReplacement;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Script;
import cd4017be.lib.util.Orientation;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpecialModelLoader
implements ICustomModelLoader {
    public static final String SCRIPT_PREFIX = "models/block/_";
    public static final String NBT_PREFIX = "models/block/.";
    public static final String NBT_PREFIX_IT = "models/item/.";
    public static final SpecialModelLoader instance = new SpecialModelLoader();
    public static final StateMapper stateMapper = new StateMapper();
    private static String mod = "";
    private IResourceManager resourceManager;
    private HashMap<String, ModelContext> scriptModels = new HashMap();
    public HashMap<ResourceLocation, IModel> models = new HashMap();
    public HashSet<String> mods = new HashSet();
    public ArrayList<IModeledTESR> tesrs = new ArrayList();

    public static void setMod(String name) {
        mod = name;
        SpecialModelLoader.instance.mods.add(name);
    }

    public static void registerFluid(Fluid fluid) {
        Block block = fluid.getBlock();
        if (block == null || !mod.equals(block.getRegistryName().func_110624_b())) {
            return;
        }
        ModelFluid model = new ModelFluid(fluid);
        SpecialModelLoader.instance.models.put(new ResourceLocation(mod, "models/block/" + fluid.getName()), (IModel)model);
        ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)stateMapper);
    }

    public static void overrideBlockModel(Block block, IModel model) {
        SpecialModelLoader.instance.models.put((ResourceLocation)new ModelResourceLocation(block.getRegistryName(), "normal"), model);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)stateMapper);
    }

    public static void registerBlockModel(Block block, IModel model) {
        String[] name = block.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/block/" + name[1]), model);
    }

    public static void registerItemModel(Item item, IModel model) {
        String[] name = item.getRegistryName().toString().split(":");
        SpecialModelLoader.instance.models.put(new ResourceLocation(name[0], "models/item/" + name[1]), model);
    }

    public static <T extends TileEntity> void registerTESR(Class<T> tile, TileEntitySpecialRenderer<T> tesr) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, tesr);
        if (tesr instanceof IModeledTESR) {
            SpecialModelLoader.instance.tesrs.add((IModeledTESR)tesr);
        }
    }

    private SpecialModelLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        for (IModeledTESR tesr : this.tesrs) {
            tesr.bakeModels(this.resourceManager);
        }
        for (ModelContext cont : this.scriptModels.values()) {
            Iterator it = cont.modules.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Module m = (Module)e.getValue();
                if (!(m instanceof Script) || ((String)e.getKey()).startsWith("tesr.")) continue;
                it.remove();
            }
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        Iterator<IModel> it = this.models.values().iterator();
        while (it.hasNext()) {
            IModel m = it.next();
            if (m instanceof IHardCodedModel) {
                ((IHardCodedModel)m).onReload();
                continue;
            }
            it.remove();
        }
        this.scriptModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (this.mods.contains(modelLocation.func_110624_b())) {
            String path = modelLocation.func_110623_a();
            return path.startsWith(SCRIPT_PREFIX) || path.startsWith(NBT_PREFIX) || path.startsWith(NBT_PREFIX_IT) || this.models.containsKey(modelLocation);
        }
        return false;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        Object model = this.models.get(modelLocation);
        if (model != null) {
            return model;
        }
        String path = modelLocation.func_110623_a();
        int p = path.indexOf(36);
        if (p >= 0) {
            model = this.loadModel(new ResourceLocation(modelLocation.func_110624_b(), path.substring(0, p)));
            model = new TextureReplacement((IModel)model, new ResourceLocation(path.substring(p + 1)));
        } else if (path.startsWith(NBT_PREFIX) || path.startsWith(NBT_PREFIX_IT)) {
            ParamertisedVariant v = ParamertisedVariant.parse(path);
            String filePath = v.splitPath();
            model = v.isBase() ? new NBTModel(CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(this.resourceManager.func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), filePath.replaceAll("\\.", "") + ".nbt")).func_110527_b()))) : new ModelVariant(this.loadModel(new ResourceLocation(modelLocation.func_110624_b(), filePath)), v);
        } else {
            p = path.indexOf(35);
            if (p >= 0) {
                String s = path.substring(p + 1);
                Orientation o = Orientation.valueOf(s.substring(0, 1).toUpperCase() + s.substring(1));
                model = this.loadModel(new ResourceLocation(modelLocation.func_110624_b(), path.substring(0, p)));
                model = new ModelVariant((IModel)model, (IModelState)o.getModelRotation());
            } else if (path.startsWith(SCRIPT_PREFIX)) {
                model = this.loadScriptModel(modelLocation);
            }
        }
        if (model != null) {
            this.models.put(modelLocation, (IModel)model);
        }
        return model;
    }

    private IModel loadScriptModel(ResourceLocation modelLocation) throws Exception {
        String methodName;
        String domain = modelLocation.func_110624_b();
        String scriptName = modelLocation.func_110623_a().substring(SCRIPT_PREFIX.length());
        int p = scriptName.indexOf(46);
        if (p >= 0) {
            methodName = scriptName.substring(p + 1);
            scriptName = scriptName.substring(0, p);
        } else {
            methodName = "main()";
        }
        ModelContext cont = this.scriptModels.get(domain);
        if (cont == null) {
            cont = new ModelContext(new ResourceLocation(domain, "models/block/"));
            this.scriptModels.put(domain, cont);
        }
        Module script = cont.getOrLoad(scriptName, this.resourceManager);
        cont.run(script, methodName);
        return new RawModelData(script, cont);
    }

    public static IntArrayModel loadTESRModel(String domain, String name) throws Exception {
        String methodName;
        int p = name.indexOf(46);
        if (p >= 0) {
            methodName = name.substring(p + 1);
            name = name.substring(0, p);
        } else {
            methodName = "main()";
        }
        ModelContext cont = SpecialModelLoader.instance.scriptModels.get(domain);
        if (cont == null) {
            cont = new ModelContext(new ResourceLocation(domain, "models/block/"));
            SpecialModelLoader.instance.scriptModels.put(domain, cont);
        }
        Module script = cont.getOrLoad("tesr." + name, SpecialModelLoader.instance.resourceManager);
        cont.run(script, methodName);
        return new IntArrayModel(cont, IntArrayModel.getTextures(script));
    }

    public static class StateMapper
    implements IStateMapper {
        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
            ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), "normal");
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                map.put(state, loc);
            }
            return map;
        }
    }
}

