/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import java.lang.reflect.Field;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public class FieldWrapper<T>
implements BooleanSupplier,
IntSupplier,
LongSupplier,
DoubleSupplier,
Supplier<T>,
IntConsumer,
LongConsumer,
DoubleConsumer,
Consumer<T> {
    private final Field field;
    public final Object owner;

    public FieldWrapper(Field field, Object owner) {
        this.field = field;
        this.owner = owner;
    }

    @Override
    public void accept(double arg0) {
        try {
            this.field.setDouble(this.owner, arg0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(long arg0) {
        try {
            this.field.setLong(this.owner, arg0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(int arg0) {
        try {
            this.field.setInt(this.owner, arg0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(T arg0) {
        try {
            this.field.set(this.owner, arg0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getAsDouble() {
        try {
            return this.field.getDouble(this.owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getAsLong() {
        try {
            return this.field.getLong(this.owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getAsInt() {
        try {
            return this.field.getInt(this.owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getAsBoolean() {
        try {
            return this.field.getBoolean(this.owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get() {
        try {
            return (T)this.field.get(this.owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

