/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.capability.AbstractInventory;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class AdvancedTank
extends AbstractInventory
implements IFluidHandler,
ITankContainer {
    public final TileEntity tile;
    public FluidStack fluid;
    public ItemStack cont;
    public final boolean fixed;
    public boolean output;
    public boolean lock;
    public int cap;
    private int need;

    public AdvancedTank(TileEntity tile, int cap, boolean out) {
        this(tile, cap, out, null);
    }

    public AdvancedTank(TileEntity tile, int cap, boolean out, Fluid type) {
        this.tile = tile;
        this.cap = cap;
        this.output = out;
        this.need = out ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        this.lock = this.fixed = type != null;
        this.fluid = this.fixed ? new FluidStack(type, 0) : null;
        this.cont = ItemStack.field_190927_a;
    }

    public void setLock(boolean lock) {
        if (this.fixed) {
            return;
        }
        if (lock) {
            this.lock = this.fluid != null;
        } else {
            this.lock = false;
            if (this.fluid != null && this.fluid.amount == 0) {
                this.fluid = null;
            }
        }
    }

    public void setOut(boolean out) {
        if (out != this.output) {
            this.output = out;
            if (out) {
                this.fillContainer();
            } else {
                this.drainContainer();
            }
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.cont = stack;
        if (!this.tile.func_145830_o() || this.tile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.output) {
            this.fillContainer();
        } else {
            this.drainContainer();
        }
        this.tile.func_70296_d();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.cont;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    public FluidStack getTank(int i) {
        return this.fluid;
    }

    @Override
    public int getCapacity(int i) {
        return this.cap;
    }

    @Override
    public void setTank(int i, FluidStack fluid) {
        this.fluid = fluid;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.fluid, this.cap)};
    }

    public int fill(FluidStack res, boolean doFill) {
        if (this.fluid == null) {
            int m = Math.min(res.amount, this.cap);
            if (doFill) {
                this.fluid = new FluidStack(res, m);
                if (this.output && m >= this.need) {
                    this.fillContainer();
                }
                this.tile.func_70296_d();
            }
            return m;
        }
        if (this.fluid.isFluidEqual(res)) {
            int m = Math.min(res.amount, this.cap - this.fluid.amount);
            if (m != 0 && doFill) {
                this.increment(m);
            }
            return m;
        }
        return 0;
    }

    public FluidStack drain(FluidStack res, boolean doDrain) {
        if (this.fluid == null || this.fluid.amount <= 0 || !this.fluid.isFluidEqual(res)) {
            return null;
        }
        int m = Math.min(res.amount, this.fluid.amount);
        FluidStack ret = new FluidStack(this.fluid, m);
        if (doDrain) {
            this.decrement(m);
        }
        return ret;
    }

    public FluidStack drain(int m, boolean doDrain) {
        if (this.fluid == null || this.fluid.amount <= 0) {
            return null;
        }
        if (this.fluid.amount < m) {
            m = this.fluid.amount;
        }
        FluidStack ret = new FluidStack(this.fluid, m);
        if (doDrain) {
            this.decrement(m);
        }
        return ret;
    }

    public int amount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public int free() {
        return this.fluid == null ? this.cap : this.cap - this.fluid.amount;
    }

    public void increment(int n) {
        this.fluid.amount += n;
        n = this.fluid.amount;
        if (this.output && n >= this.need) {
            this.fillContainer();
        }
        this.tile.func_70296_d();
    }

    public void decrement(int n) {
        if ((n = (this.fluid.amount -= n)) <= 0 && !this.lock) {
            this.fluid = null;
        }
        if (!this.output && n <= this.need) {
            this.drainContainer();
        }
        this.tile.func_70296_d();
    }

    public void fillContainer() {
        this.need = Integer.MAX_VALUE;
        if (this.cont.func_190916_E() == 0) {
            return;
        }
        if (this.fluid == null) {
            this.need = 0;
            return;
        }
        ItemFluidUtil.StackedFluidAccess acc = new ItemFluidUtil.StackedFluidAccess(this.cont);
        if (!acc.valid()) {
            return;
        }
        int n = this.fluid.amount -= acc.fill(this.fluid, true);
        int m = acc.fill(new FluidStack(this.fluid, this.cap), false);
        if (m > 0) {
            this.need = m;
        }
        if (n <= 0 && !this.lock) {
            this.fluid = null;
        }
        this.cont = acc.result();
    }

    public void drainContainer() {
        FluidStack res;
        this.need = Integer.MIN_VALUE;
        if (this.cont.func_190916_E() == 0) {
            return;
        }
        ItemFluidUtil.StackedFluidAccess acc = new ItemFluidUtil.StackedFluidAccess(this.cont);
        if (!acc.valid()) {
            return;
        }
        if (this.fluid == null) {
            this.fluid = acc.drain(this.cap, true);
            if (this.fluid == null) {
                return;
            }
        } else {
            res = acc.drain(new FluidStack(this.fluid, this.cap - this.fluid.amount), true);
            if (res != null) {
                this.fluid.amount += res.amount;
            }
        }
        if ((res = acc.drain(new FluidStack(this.fluid, this.cap), false)) != null) {
            this.need = this.cap - res.amount;
        }
        this.cont = acc.result();
    }

    public boolean transposing() {
        return this.output ? this.need <= this.cap : this.need >= 0;
    }

    public void readNBT(NBTTagCompound nbt) {
        if (this.fixed) {
            this.fluid.amount = nbt.func_74762_e("Amount");
        } else {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.lock = this.fluid != null && nbt.func_74767_n("lock");
        }
        this.cont = new ItemStack(nbt);
        if (this.cont.func_190916_E() > 0) {
            this.need = this.output ? 0 : this.cap;
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_82580_o("FluidName");
        }
        if (!this.cont.func_190926_b()) {
            this.cont.func_77955_b(nbt);
        } else {
            nbt.func_82580_o("id");
        }
        nbt.func_74757_a("lock", this.lock);
        return nbt;
    }

    public int getComparatorValue() {
        return this.fluid == null || this.fluid.amount <= 0 ? 0 : (int)((long)this.fluid.amount * 14L / (long)this.cap) + 1;
    }
}

