/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.block.BlockPipe;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.property.PropertyBlockMimic;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCoveredPipe
extends BlockPipe {
    public static final byte NEVER = -1;
    public static final byte BY_BOUNDING_BOX = 0;
    public static final byte BY_CONNECTION = 1;
    public static final byte ALWAYS = 2;
    protected byte solidMode;

    public static BlockCoveredPipe create(String id, Material m, SoundType sound, Class<? extends TileEntity> tile, final int states) {
        return new BlockCoveredPipe(id, m, sound, CON_PROPS.length + 1, tile){

            @Override
            protected PropertyInteger createBaseState() {
                return states > 1 ? PropertyInteger.func_177719_a((String)"type", (int)0, (int)(states - 1)) : null;
            }
        };
    }

    public BlockCoveredPipe setSolid(byte mode) {
        this.solidMode = mode;
        return this;
    }

    protected BlockCoveredPipe(String id, Material m, SoundType sound, int mods, Class<? extends TileEntity> tile) {
        super(id, m, sound, mods, tile);
        this.setMultilayer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String moduleVariant(int i) {
        return i < CON_PROPS.length ? CON_PROPS[i] : PropertyBlockMimic.instance.getName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<?> moduleType(int i) {
        return i < CON_PROPS.length ? Byte.class : IBlockState.class;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray;
        this.baseState = this.createBaseState();
        if (this.baseState == null) {
            iPropertyArray = new IProperty[]{};
        } else {
            IProperty[] iPropertyArray2 = new IProperty[1];
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[0] = this.baseState;
        }
        return new ExtendedBlockState((Block)this, iPropertyArray, new IUnlistedProperty[]{moduleRef, PropertyBlockMimic.instance});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState eState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)eState.getValue(moduleRef);
        if (tile == null) {
            return eState;
        }
        IBlockState cover = (IBlockState)tile.getModuleState(CON_PROPS.length);
        if (cover == null) {
            return eState;
        }
        return eState.withProperty((IUnlistedProperty)PropertyBlockMimic.instance, (Object)cover.func_177230_c().getExtendedState(cover.func_185899_b(world, pos), world, pos));
    }

    @Override
    protected IBlockState getCover(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartBlock.IModularTile) {
            return (IBlockState)((MultipartBlock.IModularTile)te).getModuleState(6);
        }
        return null;
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        byte mode = this.solidMode;
        if (mode == 2) {
            return true;
        }
        if (mode == 0) {
            return super.isSideSolid(state, world, pos, side);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartBlock.IModularTile) {
            MultipartBlock.IModularTile mt = (MultipartBlock.IModularTile)te;
            if (mode == 1 && mt.isModulePresent(side.ordinal())) {
                return true;
            }
            IBlockState cover = (IBlockState)mt.getModuleState(6);
            return cover != null && cover.isSideSolid(world, pos, side);
        }
        return false;
    }
}

