/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public interface IHookAttachable
extends IPortProvider {
    public static final int E_HOOK_ADD = 256;
    public static final int E_HOOK_REM = 512;

    public Int2ObjectMap<RelayPort> getHookPins();

    public static int getAttachmentPos(Vec3d target, EnumFacing side, EntityPlayer player) {
        target = target.func_186678_a(4.0).func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(-0.125));
        int x0 = (int)Math.floor(target.field_72450_a);
        int y0 = (int)Math.floor(target.field_72448_b);
        int z0 = (int)Math.floor(target.field_72449_c);
        switch (side) {
            case DOWN: 
            case UP: {
                target = new Vec3d(target.field_72450_a, (double)y0 + 0.5, target.field_72449_c);
                break;
            }
            case NORTH: 
            case SOUTH: {
                target = new Vec3d(target.field_72450_a, target.field_72448_b, (double)z0 + 0.5);
                break;
            }
            default: {
                target = new Vec3d((double)x0 + 0.5, target.field_72448_b, target.field_72449_c);
            }
        }
        target = target.func_178788_d(player.func_70676_i(1.0f).func_186678_a(0.5));
        int x1 = (int)Math.floor(target.field_72450_a);
        int y1 = (int)Math.floor(target.field_72448_b);
        int z1 = (int)Math.floor(target.field_72449_c);
        x1 = MathHelper.func_76125_a((int)(x0 - x1 - side.func_82601_c()), (int)-1, (int)1);
        y1 = MathHelper.func_76125_a((int)(y0 - y1 - side.func_96559_d()), (int)-1, (int)1);
        z1 = MathHelper.func_76125_a((int)(z0 - z1 - side.func_82599_e()), (int)-1, (int)1);
        int p = x0 - x1 & 0xF | (y0 - y1 & 0xF) << 4 | (z0 - z1 & 0xF) << 8;
        return p | x1 + 2 << 16 | y1 + 2 << 18 | z1 + 2 << 20;
    }

    default public boolean doAttachHook(RelayPort port) {
        Int2ObjectMap<RelayPort> pins = this.getHookPins();
        if (pins.containsKey(port.pin)) {
            return false;
        }
        pins.put(port.pin, (Object)port);
        port.orient(this.getOrientation());
        port = port.opposite;
        pins.put(port.pin, (Object)port);
        port.orient(this.getOrientation());
        this.onPortModified(port, 256);
        return true;
    }

    default public boolean removeHook(int pin, EntityPlayer player) {
        Int2ObjectMap<RelayPort> pins = this.getHookPins();
        World world = null;
        BlockPos pos = null;
        RelayPort port = (RelayPort)pins.remove(pin & 0xFFF | 0x8000);
        if (port != null) {
            port.setConnector(null, player);
            world = port.getWorld();
            pos = port.getPos();
        }
        if ((port = (RelayPort)pins.remove(pin & 0xFFF | 0x9000)) != null) {
            port.setConnector(null, player);
            world = port.getWorld();
            pos = port.getPos();
        }
        if (world == null || pos == null) {
            return false;
        }
        if (player == null) {
            ItemFluidUtil.dropStack(port.getDropped(), world, pos);
        } else if (!player.func_184812_l_()) {
            ItemFluidUtil.dropStack(port.getDropped(), (Entity)player);
        }
        this.onPortModified(null, 512);
        return true;
    }

    default public NBTTagCompound storeHooks() {
        Int2ObjectMap<RelayPort> pins = this.getHookPins();
        if (pins.isEmpty()) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry e : pins.entrySet()) {
            nbt.func_74782_a(Integer.toHexString((Integer)e.getKey()), (NBTBase)((RelayPort)e.getValue()).serializeNBT());
        }
        return nbt;
    }

    default public void loadHooks(NBTTagCompound nbt) {
        Int2ObjectMap<RelayPort> pins = this.getHookPins();
        pins.clear();
        Orientation o = this.getOrientation();
        for (String key : nbt.func_150296_c()) {
            try {
                int pin = Integer.parseInt(key, 16);
                if (pin != (pin & 0x9333)) continue;
                RelayPort port = (RelayPort)pins.get(pin);
                if (port == null) {
                    port = RelayPort.IMPLEMENTATION.apply(this, pin);
                    pins.put(port.pin, (Object)port);
                    pins.put(port.opposite.pin, (Object)port.opposite);
                    if ((pin & 0x1000) != 0) {
                        port = port.opposite;
                    }
                }
                port.deserializeNBT(nbt.func_74775_l(key));
                port.orient(o);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    default public Orientation getOrientation() {
        return Orientation.N;
    }

    public static RayTraceResult addBlockRayTrace(@Nullable RayTraceResult pre, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IHookAttachable)) {
            return pre;
        }
        Vec3d start1 = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d dir = (pre != null ? pre.field_72307_f : end).func_178788_d(start);
        Pair<Vec3d, EnumFacing> res = null;
        for (RelayPort port : ((IHookAttachable)te).getHookPins().values()) {
            Pair<Vec3d, EnumFacing> r = port.rayTrace(start1, dir);
            if (r == null) continue;
            res = r;
            dir = (Vec3d)r.getLeft();
        }
        if (res != null) {
            return new RayTraceResult(((Vec3d)res.getLeft()).func_178787_e(start), (EnumFacing)res.getRight(), pos);
        }
        return pre;
    }
}

