/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.port.Port;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Link {
    public static final Logger LOG = LogManager.getLogger((String)"rs_ctr API");
    private static final Int2ObjectMap<Link> links = new Int2ObjectOpenHashMap();
    private static int nextLinkID = 1;
    private static File file;
    private static boolean dirty;
    public final int id;
    private Port source;
    private Port sink;

    private static int newLinkID() {
        dirty = true;
        return nextLinkID++;
    }

    public static void saveData() {
        LOG.info("{} active Links cleared during server unload.", (Object)links.size());
        links.clear();
    }

    public static void loadData(File savedir) {
        nextLinkID = 1;
        file = new File(savedir, "data/signalLinkIDs.dat");
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)file);
            if (nbt == null) {
                LOG.info("Signal Link ID file not found: this must be a newly created world.");
                return;
            }
            int i = nbt.func_74762_e("nextID");
            if (i != 0) {
                nextLinkID = i;
            }
            LOG.info("Signal Link IDs sucessfully loaded: next = {}", (Object)nextLinkID);
        }
        catch (IOException e) {
            LOG.error("failed to load Signal Link IDs: ", (Throwable)e);
        }
    }

    public static Link of(int id) {
        return (Link)links.get(id);
    }

    public static void register(Port port) {
        Link link = (Link)links.get(port.linkID);
        if (link != null) {
            link.load(port);
        } else {
            links.put(port.linkID, (Object)new Link(port));
        }
    }

    private Link(Port port) {
        this.id = port.linkID;
        if (port.isMaster) {
            this.source = port;
        } else {
            this.sink = port;
        }
        if (this.id >= nextLinkID) {
            nextLinkID = this.id + 1;
            LOG.warn("It appears the used up Signal Link IDs info wasn't properly saved to disk. IDs may have been assigned duplicate!");
        }
    }

    public Link(Port source, Port sink) {
        if (!source.isMaster || sink.isMaster) {
            throw new IllegalArgumentException("invalid port directions!");
        }
        this.source = source;
        this.sink = sink;
        source.linkID = sink.linkID = Link.newLinkID();
        this.id = sink.linkID;
        links.put(sink.linkID, (Object)this);
        source.owner.setPortCallback(source.pin, sink.owner.getPortCallback(sink.pin));
        source.owner.onPortModified(source, 1);
        sink.owner.onPortModified(sink, 1);
    }

    public void load(Port port) {
        boolean link = false;
        if (port.isMaster) {
            if (this.source == null) {
                this.source = port;
                link = this.sink != null;
            }
        } else if (this.sink == null) {
            this.sink = port;
            boolean bl = link = this.source != null;
        }
        if (link) {
            this.source.onLinkLoad(this.sink);
            this.sink.onLinkLoad(this.source);
            if (!links.containsKey(this.id)) {
                return;
            }
            this.source.owner.setPortCallback(this.source.pin, this.sink.owner.getPortCallback(this.sink.pin));
        } else {
            Link.logLinkError("loaded duplicate", port);
        }
    }

    public void unload(Port port) {
        if (port != (port.isMaster ? this.source : this.sink)) {
            Link.logLinkError("unloaded invalid", port);
            if (port.isMaster) {
                port.owner.setPortCallback(port.pin, null);
            }
            return;
        }
        if (this.source != null) {
            this.source.owner.setPortCallback(this.source.pin, null);
        }
        if (port.isMaster) {
            this.source = null;
        } else {
            this.sink = null;
        }
        if (this.source == null && this.sink == null) {
            links.remove(this.id);
        }
    }

    public void disconnect() {
        if (this.source != null) {
            this.source.linkID = 0;
            this.source.owner.setPortCallback(this.source.pin, null);
            this.source.owner.onPortModified(this.source, 2);
        }
        if (this.sink != null) {
            this.sink.linkID = 0;
            this.sink.owner.onPortModified(this.sink, 2);
        }
        links.remove(this.id);
    }

    public Port source() {
        return this.source;
    }

    public Port sink() {
        return this.sink;
    }

    private static void logLinkError(String message, Port port) {
        LOG.warn("{} {} port on ID {}, hosted on pin {} of {}", (Object)message, (Object)(port.isMaster ? "master" : "slave"), (Object)port.linkID, (Object)port.pin, (Object)port.owner.getClass().getName());
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new SaveHandler());
    }

    public static class SaveHandler {
        @SubscribeEvent
        public void onSave(WorldEvent.Save ev) {
            if (!dirty || file == null) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("nextID", nextLinkID);
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)file);
                LOG.info("Signal Link IDs sucessfully saved");
                dirty = false;
            }
            catch (IOException e) {
                LOG.error("failed to save Signal Link IDs: ", (Throwable)e);
            }
        }
    }
}

