/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.com;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;

public class BlockReference {
    private static final WeakReference<World> NULL = new WeakReference<Object>(null);
    public static int INIT_LIFESPAN = 16;
    private WeakReference<World> world;
    public final int dim;
    public final BlockPos pos;
    public final EnumFacing face;
    public final int lifespan;

    public BlockReference(NBTTagCompound nbt) {
        this.world = NULL;
        this.pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        this.face = EnumFacing.field_82609_l[(nbt.func_74771_c("f") & 0xFF) % 6];
        this.dim = nbt.func_74762_e("d");
        this.lifespan = nbt.func_74771_c("t") & 0xFF;
    }

    public BlockReference(World world, BlockPos pos, EnumFacing face) {
        this.world = new WeakReference<World>(world);
        this.pos = pos;
        this.face = face;
        this.dim = world.field_73011_w.getDimension();
        this.lifespan = INIT_LIFESPAN;
    }

    public BlockReference(int dim, BlockPos pos, EnumFacing face, int lifespan) {
        this.world = NULL;
        this.pos = pos;
        this.face = face;
        this.dim = dim;
        this.lifespan = lifespan;
    }

    public boolean isLoaded() {
        World world = (World)this.world.get();
        if (world == null) {
            world = DimensionManager.getWorld((int)this.dim);
            if (world != null) {
                this.world = new WeakReference<World>(world);
            } else {
                return false;
            }
        }
        return world.func_175667_e(this.pos);
    }

    public World world() {
        return (World)this.world.get();
    }

    public IBlockState getState() {
        return this.world().func_180495_p(this.pos);
    }

    public TileEntity getTileEntity() {
        return this.world().func_175625_s(this.pos);
    }

    @Nullable
    public <C> C getCapability(Capability<C> cap) {
        TileEntity te = this.getTileEntity();
        if (te == null) {
            return null;
        }
        return (C)te.getCapability(cap, this.face);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("f", (byte)this.face.ordinal());
        nbt.func_74768_a("x", this.pos.func_177958_n());
        nbt.func_74768_a("y", this.pos.func_177956_o());
        nbt.func_74768_a("z", this.pos.func_177952_p());
        nbt.func_74768_a("d", this.dim);
        nbt.func_74774_a("t", (byte)this.lifespan);
        return nbt;
    }

    public boolean equals(Object obj) {
        return obj instanceof BlockReference && BlockReference.equal(this, (BlockReference)obj);
    }

    public static boolean equal(BlockReference a, BlockReference b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.pos.equals((Object)b.pos) && a.face == b.face && a.dim == b.dim && a.lifespan == b.lifespan;
    }

    public static boolean equalDelayed(BlockReference a, BlockReference b, int ticks) {
        if (a == null || a.lifespan - ticks <= 0) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.pos.equals((Object)b.pos) && a.face == b.face && a.dim == b.dim && a.lifespan - ticks == b.lifespan;
    }

    public static BlockReference delayed(BlockReference ref, int ticks) {
        return ref == null || ref.lifespan <= ticks ? null : new BlockReference(ref.dim, ref.pos, ref.face, ref.lifespan - ticks);
    }

    @FunctionalInterface
    public static interface BlockHandler {
        public static final BlockHandler NOP = ref -> {};

        public void updateBlock(BlockReference var1);
    }
}

