/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures.city;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.structures.WorldgenStructure;
import techguns.world.structures.city.CityBuilding;
import techguns.world.structures.city.CityBuildingType;
import techguns.world.structures.city.CityRoad;
import techguns.world.structures.city.EmptyPlane;
import techguns.world.structures.city.GenericCitySegment;
import techguns.world.structures.city.IRoad;

public class GenericCity {
    public static final int SET_AIR_HEIGHT = 3;
    public static GenericCity testCity = new GenericCity(20, 80, 12, 30, -1, new int[]{6, 4, 4, 2, 1}, new CityRoad(new MBlock(TGBlocks.CONCRETE, 3), new MBlock(TGBlocks.CONCRETE, 2)), 0.5f);
    int sizeMin;
    int sizeMax;
    int minSubSegmentSize = 8;
    int maxSubSegmentSize = 16;
    int maxHeightDiff = 3;
    float fuzzyBorder = 0.0f;
    ArrayList<WorldgenStructure> structures;
    int[] roadWidth;
    public IRoad roadType;

    public GenericCity(int sizeMin, int sizeMax, int minSubSegmentSize, int maxSubSegmentSize, int maxHeightDiff, int[] roadWidth, IRoad roadType, float fuzzyBorder) {
        this.sizeMin = sizeMin;
        this.sizeMax = sizeMax;
        this.minSubSegmentSize = minSubSegmentSize;
        this.maxSubSegmentSize = maxSubSegmentSize;
        this.maxHeightDiff = maxHeightDiff;
        this.roadWidth = roadWidth;
        this.roadType = roadType;
        this.structures = new ArrayList();
        this.fuzzyBorder = fuzzyBorder;
    }

    public void createCity(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        this.minSubSegmentSize = Math.min(sizeX, sizeZ) < 14 ? 7 : 10;
        this.maxSubSegmentSize = Math.min(sizeX, sizeZ) <= 45 ? 15 : Math.min(sizeX, sizeZ) / 3;
        if (colorType == null) {
            colorType = BlockUtils.getBiomeType(world, posX + sizeX / 2, posZ + sizeZ / 2);
        }
        GenericCitySegment rootSegment = new GenericCitySegment(this, posX, posY, posZ, sizeX, sizeZ, this.roadWidth[0], 0, colorType, rnd, null);
        rootSegment.isCenter = true;
        rootSegment.splitStep = 0;
        boolean b = rootSegment.generateSubSegments();
        if (b) {
            this.setBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, colorType, rootSegment, rnd);
        }
    }

    private void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, WorldgenStructure.BiomeColorType colorType, GenericCitySegment rootSegment, Random rnd) {
        BlockUtils.removeJunkInArea(world, posX - 1, posZ - 1, sizeX + 2, sizeZ + 2);
        BlockUtils.apply2DHeightmapFilter(world, posX - 1, posZ - 1, sizeX + 2, sizeZ + 2, BlockUtils.FILTER_GAUSSIAN_5x5);
        if (this.maxHeightDiff != -1) {
            BlockUtils.flattenArea(world, posX, posZ, sizeX, sizeZ, this.maxHeightDiff);
        }
        rootSegment.setBlocks(world, rnd);
    }

    public void placeStructure(World world, GenericCitySegment segment, Random rnd) {
        if (segment.isBorderSegment() && segment.splitStep > 2 && segment.rand.nextFloat() < this.fuzzyBorder) {
            return;
        }
        BlockUtils.fillBlocksAir(world, segment.x, segment.y + 1, segment.z, segment.sizeX, 3, segment.sizeZ);
        WorldgenStructure structure = this.getMatchingStructure(segment.sizeX, -1, segment.sizeZ, segment.rand);
        int height = structure.maxY == -1 || structure.maxY < structure.minY ? structure.minY : structure.minY + segment.rand.nextInt(structure.maxY + 1 - structure.minY);
        BlockUtils.flattenArea(world, segment.x, segment.z, segment.sizeX, segment.sizeZ, 0);
        int y = BlockUtils.getGroundY(world, segment.x + segment.sizeX / 2, segment.z + segment.sizeZ / 2);
        structure.setBlocks(world, segment.x, segment.y, segment.z, segment.sizeX, height, segment.sizeZ, segment.direction, segment.colorType, rnd);
    }

    protected WorldgenStructure getMatchingStructure(int sizeX, int sizeY, int sizeZ, Random rand) {
        ArrayList<WorldgenStructure> matchingStructures = new ArrayList<WorldgenStructure>();
        for (WorldgenStructure str : this.structures) {
            if (str.canSwapXZ) {
                if ((sizeX < str.minX || sizeZ < str.minZ) && (sizeZ < str.minX || sizeX < str.minZ) || (str.maxX != -1 && sizeX > str.maxX || str.maxZ != -1 && sizeZ > str.maxZ) && (str.maxX != -1 && sizeZ > str.maxX || str.maxZ != -1 && sizeX > str.maxZ)) continue;
                matchingStructures.add(str);
                continue;
            }
            if (sizeX < str.minX || sizeZ < str.minZ || str.maxX != -1 && sizeX > str.maxX || str.maxZ != -1 && sizeZ > str.maxZ) continue;
            matchingStructures.add(str);
        }
        if (!matchingStructures.isEmpty()) {
            return (WorldgenStructure)matchingStructures.get(rand.nextInt(matchingStructures.size()));
        }
        return new EmptyPlane(new MBlock(Blocks.field_150347_e, 0));
    }

    static {
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building1, 3, 5, 5, -1, 16, -1).setSwapXZ(true));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building2, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building3, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building4, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building5, 4, 5, 4, -1, 16, -1));
        GenericCity.testCity.structures.add(new CityBuilding(CityBuildingType.building6, 4, 5, 4, -1, 16, -1));
    }
}

