/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.entities.npcs.ZombiePoliceman;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockChestLoottable;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class PoliceStation
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/policestation");
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public PoliceStation() {
        super(13, 8, 13, 13, 8, 13);
        this.setXYZSize(13, 8, 13);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 7);
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 3);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList.add(new MBlock(TGBlocks.CONCRETE, 0));
        blockList.add(MBlockRegister.IRON_BLOCK_SMALL_INGOTS);
        blockList.add(MBlockRegister.IRON_PANE_MODERN_FENCE);
        blockList.add(MBlockRegister.AIR);
        blockList.add(new MBlock(TGBlocks.SANDBAGS, 0));
        blockList.add(new MBlock(TGBlocks.LAMP_0, 11));
        blockList.add(new MBlock(Blocks.field_150417_aV, 0));
        blockList.add(MBlockRegister.BLUE_CONCRETE_SMALL_BRICKS);
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 2));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 9));
        blockList.add(new MBlock(Blocks.field_150410_aZ, 0));
        blockList.add(MBlockRegister.OAK_PLANKS_1);
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 2, CHEST_LOOT));
        blockList.add(MBlockRegister.COBBLESTONE_7);
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.SOLDIER_SPAWN, 3, 1, 200, 1).addMobType(ZombiePoliceman.class, 1));
        blockList.add(new MBlock(TGBlocks.LAMP_0, 7));
        blockList.add(new MBlock(Blocks.field_150448_aq, 6));
        blockList.add(new MBlock(Blocks.field_150448_aq, 9));
        blockList.add(new MBlock(TGBlocks.LADDER_0, 4));
        blockList.add(new MBlock(Blocks.field_150448_aq, 7));
        blockList.add(new MBlock(Blocks.field_150448_aq, 8));
        blockList.add(new MBlock((Block)Blocks.field_150333_U, 8));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 3, CHEST_LOOT));
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MBlock(Blocks.field_180390_bo, 0));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 1));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 8));
        blocks = BlockUtils.loadStructureFromFile("policestation");
    }
}

