/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.blocks.EnumOreClusterType;
import techguns.blocks.EnumOreType;
import techguns.entities.npcs.AlienBug;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MBlockOreClusterTypeOre;
import techguns.util.MBlockOreclusterType;
import techguns.util.MultiMBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.WorldgenStructure;

public class OreClusterSpike
extends WorldgenStructure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;
    static EnumOreClusterType[] types;
    static MBlock[] ores;
    static int[] oreWeights;
    static int[] clusterWeights;
    static int totalweight;

    public OreClusterSpike() {
        super(8, 7, 8, 8, 7, 8);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        int indexRoll = OreClusterSpike.rollBlockIndex(rnd, totalweight, clusterWeights);
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 6);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType, indexRoll, rnd);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        types = new EnumOreClusterType[]{EnumOreClusterType.COAL, EnumOreClusterType.COMMON_METAL, EnumOreClusterType.COMMON_GEM, EnumOreClusterType.RARE_METAL, EnumOreClusterType.SHINY_METAL, EnumOreClusterType.SHINY_GEM, EnumOreClusterType.URANIUM};
        ores = new MBlock[]{new MBlock(Blocks.field_150365_q, 0), new MultiMBlock(new Block[]{Blocks.field_150366_p, TGBlocks.TG_ORE, TGBlocks.TG_ORE}, new int[]{0, EnumOreType.ORE_COPPER.ordinal(), EnumOreType.ORE_TIN.ordinal()}, new int[]{1, 1, 1}), new MultiMBlock(new Block[]{Blocks.field_150450_ax, Blocks.field_150369_x}, new int[]{0, 0}, new int[]{1, 1}), new MBlock(TGBlocks.TG_ORE, EnumOreType.ORE_LEAD.ordinal()), new MultiMBlock(new Block[]{Blocks.field_150352_o, TGBlocks.TG_ORE}, new int[]{0, EnumOreType.ORE_TITANIUM.ordinal()}, new int[]{1, 1}), new MultiMBlock(new Block[]{Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150348_b}, new int[]{0, 0, 0}, new int[]{2, 1, 3}), new MultiMBlock(new Block[]{TGBlocks.TG_ORE, Blocks.field_150348_b}, new int[]{EnumOreType.ORE_URANIUM.ordinal(), 0}, new int[]{1, 1})};
        oreWeights = new int[]{1, 1, 1, 1, 1, 1, 1};
        clusterWeights = new int[]{5, 10, 10, 10, 5, 2, 3};
        totalweight = 0;
        Arrays.stream(clusterWeights).forEach(i -> totalweight += i);
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.HOLE, 4, 2, 200, 1).addMobType(AlienBug.class, 1));
        blockList.add(new MultiMBlock(new Block[]{Blocks.field_150348_b, Blocks.field_150350_a}, new int[]{0, 0}, new int[]{1, 1}));
        blockList.add(new MBlock((Block)TGBlocks.SLIMY_LADDER, 4));
        blockList.add(new MBlock(TGBlocks.SLIMY_BLOCK, 0));
        blockList.add(new MBlock(Blocks.field_150348_b, 0));
        blockList.add(new MBlockOreClusterTypeOre(ores, oreWeights, new MBlock(Blocks.field_150348_b, 0), 0.5f));
        blockList.add(new MBlock((Block)TGBlocks.SLIMY_LADDER, 2));
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.5f, ores));
        blockList.add(new MBlock((Block)TGBlocks.SLIMY_LADDER, 3));
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.0f, null));
        blocks = BlockUtils.loadStructureFromFile("orecluster_spike");
    }
}

