/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class Helipad
extends WorldgenStructure {
    public Helipad(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int x;
        int offset;
        if (sizeX < 7 || sizeZ < 7) {
            return;
        }
        if (sizeX > 9) {
            offset = (sizeX - 9) / 2;
            posX += offset;
            sizeX = 9;
        }
        if (sizeZ > 9) {
            offset = (sizeZ - 9) / 2;
            posZ += offset;
            sizeZ = 9;
        }
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        if (sizeX == 9 && sizeZ == 9) {
            for (int z = 1; z < sizeZ - 1; ++z) {
                world.func_180501_a((BlockPos)p.func_181079_c(posX, posY, posZ + z), MBlockRegister.HELIPAD_WIREFRAME.getState(), 2);
                world.func_180501_a((BlockPos)p.func_181079_c(posX + sizeX - 1, posY, posZ + z), MBlockRegister.HELIPAD_WIREFRAME.getState(), 2);
            }
            ++posX;
            sizeX = 7;
            for (x = 0; x < sizeX; ++x) {
                world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY, posZ), MBlockRegister.HELIPAD_WIREFRAME.getState(), 2);
                world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY, posZ + sizeZ - 1), MBlockRegister.HELIPAD_WIREFRAME.getState(), 2);
            }
            ++posZ;
            sizeZ = 7;
        } else {
            sizeX = 7;
            sizeZ = 7;
        }
        for (x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + 1, posZ + z), MBlockRegister.HELIPAD_HAZARDBLOCK.getState(), 2);
                    continue;
                }
                world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + 1, posZ + z), MBlockRegister.HELIPAD_CONCRETE.getState(), 2);
            }
        }
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 2, posY + 1, posZ + 2), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 3, posY + 1, posZ + 2), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 4, posY + 1, posZ + 2), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 3, posY + 1, posZ + 3), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 2, posY + 1, posZ + 4), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 3, posY + 1, posZ + 4), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + 4, posY + 1, posZ + 4), MBlockRegister.HELIPAD_GLOWBLOCK.getState(), 2);
    }
}

