/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.BlockTGDoor2x1;
import techguns.blocks.BlockTGLadder;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.entities.npcs.ZombieMiner;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockChestLoottable;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class FactoryHouseSmall
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/factory_building");
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public FactoryHouseSmall(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.setSwapXZ(true);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 7);
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 3);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList.add(new MBlock(TGBlocks.CONCRETE, 2));
        blockList.add(MBlockRegister.TECHNICAL_BLOCK_SCAFFOLD);
        blockList.add(MBlockRegister.FACTORY_PLATE);
        blockList.add(new MBlock(Blocks.field_150410_aZ, 0));
        blockList.add(MBlockRegister.TECHNICAL_CONCRETE);
        blockList.add(MBlockRegister.FACTORY_CRATE);
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 5, CHEST_LOOT));
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.NORTH.ordinal()));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.WEST.ordinal()));
        blockList.add(MBlockRegister.FACTORY_PLATE_DOTTED);
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MBlock(TGBlocks.BUNKER_DOOR.func_176223_P().func_177226_a((IProperty)BlockTGDoor2x1.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTGDoor2x1.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockTGDoor2x1.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        blockList.add(new MBlock(TGBlocks.BUNKER_DOOR.func_176223_P().func_177226_a((IProperty)BlockTGDoor2x1.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTGDoor2x1.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockTGDoor2x1.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER)));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.UP.ordinal()));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.SOUTH.ordinal()));
        blockList.add(new MBlock(Blocks.field_150460_al, 3));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.EAST.ordinal()));
        blockList.add(new MBlock(TGBlocks.LADDER_0.func_176223_P().func_177226_a((IProperty)BlockTGLadder.FACING, (Comparable)EnumFacing.SOUTH)));
        blockList.add(new MBlock(Blocks.field_150411_aY, 0));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.WEST.ordinal()));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.HOLE, 5, 2, 150, 2).addMobType(ZombieMiner.class, 1));
        blocks = BlockUtils.loadStructureFromFile("factory_building_small");
    }
}

