/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.TGFluids;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.blocks.EnumOreClusterType;
import techguns.entities.npcs.ArmySoldier;
import techguns.entities.npcs.Commando;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MBlockOreclusterType;
import techguns.util.MultiMMBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.WorldgenStructure;

public class DesertOilCluster
extends WorldgenStructure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;
    static EnumOreClusterType[] types;
    static MBlock[] ores;
    static MBlock oilblock;
    static MBlock oilblockSand;
    static int[] oreWeights;
    static int[] clusterWeights;
    static int totalweight;

    public DesertOilCluster() {
        super(11, 10, 11, 11, 10, 11);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        int indexRoll = DesertOilCluster.rollBlockIndex(rnd, totalweight, clusterWeights);
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 6);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY - 4, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType, indexRoll, rnd);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY - 4, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        types = new EnumOreClusterType[]{EnumOreClusterType.OIL};
        ores = null;
        oreWeights = new int[]{1};
        clusterWeights = new int[]{10};
        totalweight = 0;
        Arrays.stream(clusterWeights).forEach(i -> totalweight += i);
        if (TGFluids.OIL_WORLDSPAWN != null) {
            MBlock oil = new MBlock(TGFluids.OIL_WORLDSPAWN.getBlock().func_176223_P());
            ores = new MBlock[]{oil};
            oilblock = oil;
            oilblockSand = new MultiMMBlock(new MBlock[]{oil, new MBlock((Block)Blocks.field_150354_m, 0)}, new int[]{1, 1});
        } else {
            ores = new MBlock[]{new MBlock(Blocks.field_150322_A, 0)};
            oilblock = new MBlock((Block)Blocks.field_150353_l, 0);
            oilblockSand = new MBlock(Blocks.field_189877_df, 0);
        }
        blockList.add(new MBlock(Blocks.field_150322_A, 0));
        blockList.add(new MBlock(TGBlocks.SANDBAGS, 0));
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.SOLDIER_SPAWN, 3, 1, 200, 1).addMobType(ArmySoldier.class, 4).addMobType(Commando.class, 1));
        blockList.add(oilblockSand);
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.5f, ores));
        blockList.add(oilblock);
        blockList.add(new MBlockOreclusterType(types, clusterWeights, 0.0f, null));
        blockList.add(oilblock);
        blocks = BlockUtils.loadStructureFromFile("desert_oil_cluster");
    }
}

