/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.util.MBlock;
import techguns.world.BlockRotator;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class Barracks
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/militarybase_barracks");
    MBlock b_pillar = MBlockRegister.BARRACKS_WOOD_PILLAR;
    MBlock b_wall = MBlockRegister.BARRACKS_WOOD_WALL;
    MBlock b_floor = MBlockRegister.BARRACKS_WOOD_FLOOR;
    MBlock b_scaffold = MBlockRegister.BARRACKS_WOOD_SCAFFOLD;
    MBlock b_roof = MBlockRegister.BARRACKS_WOOD_ROOF;
    MBlock b_roofSlab = MBlockRegister.BARRACKS_WOOD_ROOFSLAB;
    MBlock b_stairs = MBlockRegister.WOOD_STAIRS_OAK;
    MBlock b_torch = MBlockRegister.TGLAMP;
    MBlock b_ground = MBlockRegister.GRAVEL;
    MBlock b_window = MBlockRegister.GLASS_PANE;

    public Barracks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int dz;
        int dx;
        int zoffset;
        int xoffset;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        EnumFacing facing = Barracks.directionToFacing(direction);
        switch (direction) {
            case 0: {
                posX += 2;
                sizeX -= 2;
                break;
            }
            case 1: {
                posZ += 2;
                sizeZ -= 2;
                break;
            }
            case 2: {
                sizeX -= 2;
                break;
            }
            default: {
                sizeZ -= 2;
            }
        }
        sizeX -= (sizeX - 1) % 4;
        sizeZ -= (sizeZ - 1) % 4;
        sizeY = 7;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    if (y == 0) {
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_ground.getState(), 2);
                        continue;
                    }
                    if (y == 1) {
                        if (x % 4 != 0 || z % 4 != 0) continue;
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_pillar.getState(), 2);
                        continue;
                    }
                    if (y == 2) {
                        if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_scaffold.getState(), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_floor.getState(), 2);
                        continue;
                    }
                    if (y <= 4) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        if (x % 4 == 0 && z % 4 == 0) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_scaffold.getState(), 2);
                            continue;
                        }
                        if (y == 4 && (x % 4 == 2 || z % 4 == 2)) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_window.getState(), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_wall.getState(), 2);
                        continue;
                    }
                    if (y == 5) {
                        if (x != 0 && z != 0 && x != sizeX - 1 && z != sizeZ - 1) continue;
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_scaffold.getState(), 2);
                        continue;
                    }
                    if (y != 6) continue;
                    if (x == 0 || z == 0 || x == sizeX - 1 || z == sizeZ - 1) {
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_roofSlab.getState(), 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.b_roof.getState(), 2);
                }
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = -1;
                dz = 0;
                break;
            }
            case 1: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = 0;
                dx = 0;
                dz = -1;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 8 * 4 + 2;
                dx = 1;
                dz = 0;
                break;
            }
            default: {
                xoffset = sizeX / 8 * 4 + 2;
                zoffset = sizeZ - 1;
                dx = 0;
                dz = 1;
            }
        }
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 4, posZ + zoffset));
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 3, posZ + zoffset));
        ItemDoor.func_179235_a((World)world, (BlockPos)p.func_181079_c(posX + xoffset, posY + 3, posZ + zoffset), (EnumFacing)facing.func_176734_d(), (Block)Blocks.field_180413_ao, (boolean)false);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx, posY + 5, posZ + zoffset + dz), BlockRotator.getWithFacing(this.b_torch.getState(), facing.func_176734_d()), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx, posY + 2, posZ + zoffset + dz), BlockRotator.getWithFacing(this.b_stairs.getState(), facing.func_176734_d()), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx * 2, posY + 1, posZ + zoffset + dz * 2), BlockRotator.getWithFacing(this.b_stairs.getState(), facing.func_176734_d()), 2);
        int xHalf = sizeX / 2;
        int zHalf = sizeZ / 2;
        for (int x = 1; x < sizeX - 1; ++x) {
            for (int z = 1; z < sizeZ - 1; ++z) {
                for (int y = 3; y < 6; ++y) {
                    if (x == 1 || z == 1 || x == sizeX - 2 || z == sizeZ - 2) {
                        if (y == 5 && (x % 4 == 2 || z % 4 == 2)) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), BlockRotator.getWithFacing(this.b_torch.getState(), EnumFacing.UP), 2);
                        }
                        if (y != 3 || x % 4 != 0 && z % 4 != 0 || x == xoffset || z == zoffset) continue;
                        EnumFacing chestrot = EnumFacing.EAST;
                        if (z % 4 == 0) {
                            if (x > xHalf) {
                                chestrot = chestrot.func_176734_d();
                            }
                        } else if (x % 4 == 0) {
                            chestrot = EnumFacing.SOUTH;
                            if (z > zHalf) {
                                chestrot = chestrot.func_176734_d();
                            }
                        }
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), BlockRotator.getWithFacing(Blocks.field_150486_ae.func_176223_P(), chestrot), 2);
                        TileEntity tile = world.func_175625_s((BlockPos)p);
                        if (tile == null || !(tile instanceof TileEntityChest)) continue;
                        ((TileEntityChest)tile).func_189404_a(CHEST_LOOT, world.field_73012_v.nextLong());
                        continue;
                    }
                    if (!(x != 2 && z != 2 && x != sizeX - 3 && z != sizeZ - 3 || sizeX / 4 <= 1 && sizeZ / 4 <= 1 || y != 3 || x % 4 != 2 || z % 4 != 2 || x == xoffset || z == zoffset)) {
                        if (x == 2) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(1), 3);
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x - 1, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(9), 3);
                        } else if (x == sizeX - 3) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(3), 3);
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x + 1, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(11), 3);
                        } else if (z == 2) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(2), 3);
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z - 1), Blocks.field_150324_C.func_176203_a(10), 3);
                        } else if (z == sizeZ - 3) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), Blocks.field_150324_C.func_176203_a(0), 3);
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z + 1), Blocks.field_150324_C.func_176203_a(8), 3);
                        }
                    }
                    if (y != 5 || x % 8 != 0 || z % 8 != 0) continue;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), BlockRotator.getWithFacing(this.b_torch.getState(), EnumFacing.UP), 2);
                }
            }
        }
    }
}

