/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import techguns.TGBlocks;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.entities.npcs.ArmySoldier;
import techguns.entities.npcs.AttackHelicopter;
import techguns.entities.npcs.Commando;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.EnumLootType;
import techguns.world.dungeon.presets.specialblocks.MBlockChestLoottable;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class AircraftCarrier
extends WorldgenStructure {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("techguns", "chests/aircraftcarrier");
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public AircraftCarrier(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.lootTier = EnumLootType.TIER2;
    }

    @Override
    public void spawnStructureWorldgen(World world, int chunkX, int chunkZ, int sizeX, int sizeY, int sizeZ, Random rnd, Biome biome) {
        int y = BlockUtils.getValidSpawnYWater(world, chunkX * 16, chunkZ * 16, sizeX, sizeZ, 2);
        if (y < 0) {
            return;
        }
        int x = chunkX * 16;
        int z = chunkZ * 16;
        this.setBlocks(world, x, y - 3, z, sizeX, sizeY, sizeZ, rnd.nextInt(4), AircraftCarrier.getBiomeColorTypeFromBiome(biome), rnd);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList.add(MBlockRegister.HELIPAD_HAZARDBLOCK);
        blockList.add(MBlockRegister.FACTORY_PLATE_DOTTED_GREY);
        blockList.add(MBlockRegister.FACTORY_PLATE_VERY_RUSTY);
        blockList.add(MBlockRegister.FACTORY_PLATE_WORN_COLUMN);
        blockList.add(MBlockRegister.FACTORY_WIREFRAME);
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 5, LOOT_TABLE));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.NORTH.ordinal()));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.WEST.ordinal()));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 5, LOOT_TABLE));
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(MBlockRegister.SUPPLY_CRATES);
        blockList.add(MBlockRegister.SUPPLY_CRATES);
        blockList.add(new MBlock(Blocks.field_150410_aZ, 0));
        blockList.add(MBlockRegister.TECHNICAL_PIPES);
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.SOUTH.ordinal()));
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.EAST.ordinal()));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 2));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 9));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 8));
        blockList.add(MBlockRegister.FACTORY_SHINY_METAL);
        blockList.add(new MBlock(Blocks.field_150359_w, 0));
        blockList.add(new MBlock(Blocks.field_150411_aY, 0));
        blockList.add(MBlockRegister.TECHNICAL2_SCAFFOLD_TRANSPARENT);
        blockList.add(new MBlock(TGBlocks.LAMP_0, EnumFacing.UP.ordinal()));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 0));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 1));
        blockList.add(new MBlock((Block)TGBlocks.BUNKER_DOOR, 3));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 3, LOOT_TABLE));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 2, LOOT_TABLE));
        blockList.add(MBlockRegister.ALUMINIUM_STAIRS_WEST);
        blockList.add(MBlockRegister.ALUMINIUM_STAIRS_EAST);
        blockList.add(new MBlock(TGBlocks.LADDER_0, 0));
        blockList.add(MBlockRegister.IRON_BLOCK_VENTS);
        blockList.add(MBlockRegister.TECHNICAL_GRATE);
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 3, LOOT_TABLE));
        blockList.add(MBlockRegister.TECHNICAL2_FAN);
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 4, LOOT_TABLE));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.HOLE, 6, 2, 150, 2).addMobType(ArmySoldier.class, 1).addMobType(Commando.class, 1));
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.SOLDIER_SPAWN, 1, 1, 200, 0).addMobType(AttackHelicopter.class, 1));
        blockList.add(MBlockRegister.SUPPLY_CRATES_CHANCE);
        blocks = BlockUtils.loadStructureFromFile("aircraft_carrier");
    }
}

