/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.dungeon.presets;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import techguns.entities.npcs.SkeletonSoldier;
import techguns.entities.npcs.ZombieSoldier;
import techguns.tileentities.TGSpawnerTileEnt;
import techguns.world.dungeon.DungeonSegment;
import techguns.world.dungeon.DungeonTemplate;
import techguns.world.dungeon.IDungeonPath;
import techguns.world.dungeon.MazeDungeonPath;
import techguns.world.dungeon.TemplateSegment;
import techguns.world.dungeon.presets.IDungeonPreset;

public class PresetCastle
implements IDungeonPreset {
    int sizeXZ = 0;
    int sizeY = 0;
    private static final ResourceLocation LOOTTABLE = new ResourceLocation("techguns", "chests/castle");
    ArrayList<DungeonTemplate> undergroundTemplates = new ArrayList();
    ArrayList<DungeonTemplate> lowerTemplates = new ArrayList();
    ArrayList<DungeonTemplate> midTemplates = new ArrayList();
    ArrayList<DungeonTemplate> upperTemplates = new ArrayList();
    ArrayList<DungeonTemplate> topTemplates = new ArrayList();
    ArrayList<DungeonTemplate> roofTemplates = new ArrayList();

    public PresetCastle() {
        this.undergroundTemplates.add(DungeonTemplate.dungeonTemplates.get("ncdung1").setLoottable(LOOTTABLE));
        this.lowerTemplates.add(DungeonTemplate.dungeonTemplates.get("nclower1").setLoottable(LOOTTABLE));
        this.midTemplates.add(DungeonTemplate.dungeonTemplates.get("ncmid1").setLoottable(LOOTTABLE));
        this.upperTemplates.add(DungeonTemplate.dungeonTemplates.get("ncupper1").setLoottable(LOOTTABLE));
        this.topTemplates.add(DungeonTemplate.dungeonTemplates.get("nctop1").setLoottable(LOOTTABLE));
        this.roofTemplates.add(DungeonTemplate.dungeonTemplates.get("ncroof1").setLoottable(LOOTTABLE));
    }

    @Override
    public DungeonSegment getSegment(TemplateSegment.SegmentType type, int y, int yMin, int yMax, boolean isSegmentAbove, boolean isSegmentBelow, int seed) {
        Random rand = new Random(seed);
        if (y == -1) {
            return this.roofTemplates.get((int)rand.nextInt((int)this.roofTemplates.size())).segments.get((Object)type);
        }
        if (y == yMin) {
            return this.undergroundTemplates.get((int)rand.nextInt((int)this.undergroundTemplates.size())).segments.get((Object)type);
        }
        if (y <= yMin + 1) {
            return this.lowerTemplates.get((int)rand.nextInt((int)this.lowerTemplates.size())).segments.get((Object)type);
        }
        if (y < yMax - 2) {
            return this.midTemplates.get((int)rand.nextInt((int)this.midTemplates.size())).segments.get((Object)type);
        }
        if (y < yMax - 1) {
            return this.upperTemplates.get((int)rand.nextInt((int)this.upperTemplates.size())).segments.get((Object)type);
        }
        return this.topTemplates.get((int)rand.nextInt((int)this.topTemplates.size())).segments.get((Object)type);
    }

    @Override
    public int getSizeXZ() {
        if (this.sizeXZ == 0) {
            this.sizeXZ = this.midTemplates.get((int)0).sizeXZ;
        }
        return this.sizeXZ;
    }

    @Override
    public int getSizeY() {
        if (this.sizeY == 0) {
            this.sizeY = this.midTemplates.get((int)0).sizeY;
        }
        return this.sizeY;
    }

    @Override
    public void initDungeonPath(IDungeonPath d_path) {
        MazeDungeonPath path = (MazeDungeonPath)d_path;
        path.startHeightLevel = 1;
        path.chanceStraight = 0.8f;
        path.chanceRamp = 0.5f;
        path.chanceRoom = 0.25f;
        path.chanceFork = 0.4f;
        path.chanceUp = 0.65f;
        path.useFoundations = true;
        path.usePillars = true;
        path.useRoof = true;
    }

    @Override
    public void initSpawner(TGSpawnerTileEnt spawner) {
        spawner.setParams(2, 2, 200, 2);
        spawner.addMobType(ZombieSoldier.class, 1);
        spawner.addMobType(SkeletonSoldier.class, 1);
    }
}

