/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.dungeon;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.minecraft.world.World;
import techguns.world.Structure;
import techguns.world.dungeon.DungeonTemplate;
import techguns.world.dungeon.TemplateSegment;

public class DungeonSegment
implements Serializable {
    private static final long serialVersionUID = 2L;
    public transient DungeonTemplate template;
    public TemplateSegment.SegmentType type;
    public Structure structure;

    public DungeonSegment(DungeonTemplate template, TemplateSegment.SegmentType type) {
        this.template = template;
        this.type = type;
    }

    public void scanBlocks(World world, int posX, int posY, int posZ) {
        TemplateSegment segment = TemplateSegment.templateSegments.get((Object)this.type);
        int x = posX + 1 + segment.col * (this.template.sizeXZ + 1);
        int y = posY;
        int z = posZ + 1 + segment.row * (this.template.sizeXZ + 1);
        this.structure = Structure.scanBlocks(world, x, y, z, this.template.sizeXZ, this.template.sizeY * segment.sizeY, this.template.sizeXZ);
    }

    public void placeTemplateSegment(World world, int posX, int posY, int posZ, int rotation) {
        TemplateSegment segment = TemplateSegment.templateSegments.get((Object)this.type);
        int x = posX + 1 + segment.col * (this.template.sizeXZ + 1);
        int y = posY;
        int z = posZ + 1 + segment.row * (this.template.sizeXZ + 1);
        this.structure.placeBlocks(world, x, y, z, rotation);
    }

    public void placeSegment(World world, int posX, int posY, int posZ, int rotation) {
        this.structure.placeBlocks(world, posX, posY, posZ, rotation);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.template.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String templateName = in.readUTF();
        this.template = DungeonTemplate.dungeonTemplates.get(templateName);
    }
}

