/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.dungeon;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.world.dungeon.IDungeonPath;
import techguns.world.dungeon.presets.IDungeonPreset;

public class Dungeon {
    private static final int GENERATE_ATTEMPTS = 5;
    IDungeonPreset preset;
    int maxSizeX;
    int maxSizeY;
    int maxSizeZ;
    int sX;
    int sY;
    int sZ;
    public EnumFacing startRotation;
    public BlockPos startPos;

    public Dungeon(IDungeonPreset preset) {
        this.preset = preset;
    }

    public void generate(World world, int posX, int posY, int posZ, int maxSizeX, int maxSizeY, int maxSizeZ) {
        this.maxSizeX = maxSizeX;
        this.maxSizeY = maxSizeY;
        this.maxSizeZ = maxSizeZ;
        this.sX = maxSizeX / this.preset.getSizeXZ();
        this.sY = maxSizeY / this.preset.getSizeY();
        this.sZ = maxSizeZ / this.preset.getSizeXZ();
        IDungeonPath path = null;
        for (int i = 0; i < 5; ++i) {
            IDungeonPath p = this.preset.getDungeonPath(this.sX, this.sY, this.sZ, world.field_73012_v);
            this.preset.initDungeonPath(p);
            p.generatePath();
            if (path != null && p.getNumSegments() <= path.getNumSegments()) continue;
            path = p;
        }
        path.generateDungeon(world, posX, posY, posZ, this.preset);
        path.generateNPCSpawners(world, posX, posY, posZ, this.preset);
        this.startPos = path.getStartPos();
        this.startRotation = path.getEntranceRotation();
    }
}

