/*
 * Decompiled with CFR 0.152.
 */
package techguns.world;

import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import techguns.world.StructureLandType;
import techguns.world.StructureSize;
import techguns.world.structures.WorldgenStructure;

public class TGStructureSpawn {
    WorldgenStructure structure;
    int spawnWeight;
    ArrayList<BiomeDictionary.Type> biomeWhitelist;
    ArrayList<Integer> dimensionIDs;
    StructureSize size;
    ArrayList<StructureLandType> allowedTypes;

    public TGStructureSpawn(WorldgenStructure structure, int spawnWeight, ArrayList<BiomeDictionary.Type> biomeWhitelist, ArrayList<Integer> dimensionIDs, ArrayList<StructureLandType> allowedTypes, StructureSize size) {
        this.structure = structure;
        this.spawnWeight = spawnWeight;
        this.biomeWhitelist = biomeWhitelist;
        this.dimensionIDs = dimensionIDs;
        this.allowedTypes = allowedTypes;
        this.size = size;
    }

    public int getWeightForBiome(Biome biome, StructureSize size, StructureLandType type, int dimensionid) {
        if (this.size != size) {
            return 0;
        }
        if (!this.allowedTypes.contains((Object)type)) {
            return 0;
        }
        if (!this.dimensionMatches(dimensionid)) {
            return 0;
        }
        if (this.biomeWhitelist == null) {
            return this.spawnWeight;
        }
        for (int i = 0; i < this.biomeWhitelist.size(); ++i) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)this.biomeWhitelist.get(i))) continue;
            return this.spawnWeight;
        }
        return 0;
    }

    public boolean dimensionMatches(World w) {
        int id = w.field_73011_w.getDimension();
        return this.dimensionIDs.contains(id);
    }

    public boolean dimensionMatches(int id) {
        return this.dimensionIDs.contains(id);
    }
}

