/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.util.MBlock;
import techguns.world.EnumLootType;
import techguns.world.structures.WorldgenStructure;

public class MultiMMBlock
extends MBlock {
    protected MBlock[] mBlocks;
    protected int[] weights;
    protected IBlockState[] states;
    protected int totalWeight;

    public MultiMMBlock(MBlock[] mblocks, int[] weights) {
        super(mblocks[0]);
        this.mBlocks = mblocks;
        this.weights = weights;
        this.calcTotalweight();
    }

    protected void calcTotalweight() {
        this.totalWeight = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            this.totalWeight += this.weights[i];
        }
    }

    @Override
    public void setBlock(World w, BlockPos.MutableBlockPos pos, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        int index = this.rollBlockIndex(w.field_73012_v);
        this.mBlocks[index].setBlock(w, pos, rotation, loottype, biome);
    }

    protected int rollBlockIndex(Random rnd) {
        int roll = rnd.nextInt(this.totalWeight + 1);
        int sum = 0;
        for (int i = 0; i < this.mBlocks.length; ++i) {
            if (roll > (sum += this.weights[i])) continue;
            return i;
        }
        return this.weights.length;
    }
}

